/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModLoot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class OriginLootCondition
implements LootItemCondition {
    private final ResourceLocation origin;
    private final ResourceLocation layer;

    private OriginLootCondition(ResourceLocation origin) {
        this.origin = origin;
        this.layer = null;
    }

    private OriginLootCondition(ResourceLocation origin, ResourceLocation layer) {
        this.origin = origin;
        this.layer = layer;
    }

    public LootItemConditionType m_7940_() {
        return ModLoot.ORIGIN_LOOT_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        Optional optional = ModComponents.ORIGIN.maybeGet(lootContext.m_78953_(LootContextParams.f_81455_));
        if (optional.isPresent()) {
            OriginComponent component = (OriginComponent)optional.get();
            HashMap<OriginLayer, Origin> map = component.getOrigins();
            boolean matches = false;
            for (Map.Entry<OriginLayer, Origin> entry : map.entrySet()) {
                if (this.layer != null) {
                    if (!entry.getKey().getIdentifier().equals((Object)this.layer) || !entry.getValue().getIdentifier().equals((Object)this.origin)) continue;
                    matches = true;
                    break;
                }
                if (!entry.getValue().getIdentifier().equals((Object)this.origin)) continue;
                matches = true;
                break;
            }
            return matches;
        }
        return false;
    }

    public static LootItemCondition.Builder builder(String originId) {
        return OriginLootCondition.builder(new ResourceLocation(originId));
    }

    public static LootItemCondition.Builder builder(ResourceLocation origin) {
        return () -> new OriginLootCondition(origin);
    }

    public static LootItemCondition.Builder builder(String originId, String layerId) {
        return OriginLootCondition.builder(new ResourceLocation(originId), new ResourceLocation(layerId));
    }

    public static LootItemCondition.Builder builder(ResourceLocation origin, ResourceLocation layer) {
        return () -> new OriginLootCondition(origin, layer);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<OriginLootCondition> {
        public void toJson(JsonObject jsonObject, OriginLootCondition originLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("origin", originLootCondition.origin.toString());
            if (originLootCondition.layer != null) {
                jsonObject.addProperty("layer", originLootCondition.layer.toString());
            }
        }

        public OriginLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ResourceLocation origin = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"origin"));
            if (jsonObject.has("layer")) {
                ResourceLocation layer = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"layer"));
                return new OriginLootCondition(origin, layer);
            }
            return new OriginLootCondition(origin);
        }
    }
}

