/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.mixin.DrawContextAccessor;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class OriginDisplayScreen
extends Screen {
    private static final ResourceLocation WINDOW = new ResourceLocation("origins", "textures/gui/choose_origin.png");
    private Origin origin;
    private OriginLayer layer;
    private boolean isOriginRandom;
    private Component randomOriginText;
    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    private float time = 0.0f;
    protected int guiTop;
    protected int guiLeft;
    protected final boolean showDirtBackground;
    private final LinkedList<RenderedBadge> renderedBadges = new LinkedList();
    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0.0;

    public OriginDisplayScreen(Component title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin, OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
        this.time = 0.0f;
    }

    public void setRandomOriginText(Component text) {
        this.randomOriginText = text;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 182) / 2;
    }

    public Origin getCurrentOrigin() {
        return this.origin;
    }

    public OriginLayer getCurrentLayer() {
        return this.layer;
    }

    public void m_280273_(GuiGraphics context) {
        if (this.showDirtBackground) {
            super.m_280039_(context);
        } else {
            super.m_280273_(context);
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.time += delta;
        this.m_280273_(context);
        this.renderOriginWindow(context, mouseX, mouseY);
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.origin != null) {
            this.renderScrollbar(context, mouseX, mouseY);
            this.renderBadgeTooltip(context, mouseX, mouseY);
        }
    }

    private void renderScrollbar(GuiGraphics context, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            return;
        }
        context.m_280218_(WINDOW, this.guiLeft + 155, this.guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = (float)this.scrollPos / (float)this.currentMaxScroll;
        scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
        if (this.scrolling) {
            u += 6;
        } else if (mouseX >= this.guiLeft + 156 && mouseX < this.guiLeft + 156 + 6 && mouseY >= this.guiTop + scrollbarY && mouseY < this.guiTop + scrollbarY + 27) {
            u += 6;
        }
        context.m_280218_(WINDOW, this.guiLeft + 156, this.guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean canScroll() {
        return this.origin != null && this.currentMaxScroll > 0;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.canScroll()) {
            this.scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = (float)this.scrollPos / (float)this.currentMaxScroll;
            scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
            if (mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollbarY) && mouseY < (double)(this.guiTop + scrollbarY + 27)) {
                this.scrolling = true;
                this.scrollDragStart = scrollbarY;
                this.mouseDragStart = mouseY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int delta = (int)(mouseY - this.mouseDragStart);
            int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
            float part = (float)(newScrollPos - 36) / 105.0f;
            this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(GuiGraphics context, int mouseX, int mouseY) {
        for (RenderedBadge rb : this.renderedBadges) {
            if (mouseX < rb.x || mouseX >= rb.x + 9 || mouseY < rb.y || mouseY >= rb.y + 9 || !rb.hasTooltip()) continue;
            int widthLimit = this.f_96543_ - mouseX - 24;
            ((DrawContextAccessor)context).invokeDrawTooltip(this.f_96547_, rb.getTooltipComponents(this.f_96547_, widthLimit), mouseX, mouseY, DefaultTooltipPositioner.f_262752_);
        }
    }

    protected Component getTitleText() {
        return Component.m_130674_((String)"Origins");
    }

    private void renderOriginWindow(GuiGraphics context, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(context, 16, 0);
        if (this.origin != null) {
            this.renderOriginContent(context, mouseX, mouseY);
        }
        context.m_280398_(WINDOW, this.guiLeft, this.guiTop, 1, 0.0f, 0.0f, 176, 182, 256, 256);
        if (this.origin != null) {
            context.m_280168_().m_85836_();
            context.m_280168_().m_252880_(0.0f, 0.0f, 5.0f);
            this.renderOriginName(context);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WINDOW);
            this.renderOriginImpact(context, mouseX, mouseY);
            context.m_280168_().m_85849_();
            Component title = this.getTitleText();
            context.m_280137_(this.f_96547_, title.getString(), this.f_96543_ / 2, this.guiTop - 15, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(GuiGraphics context, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                context.m_280218_(WINDOW, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            context.m_280218_(WINDOW, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            MutableComponent ttc = Component.m_237115_((String)"origins.gui.impact.impact").m_130946_(": ").m_7220_((Component)impact.getTextComponent());
            context.m_280557_(this.f_96547_, (Component)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(GuiGraphics context) {
        FormattedText originName = this.f_96547_.m_92854_((FormattedText)this.getCurrentOrigin().getName(), 140);
        context.m_280488_(this.f_96547_, originName.getString(), this.guiLeft + 39, this.guiTop + 19, 0xFFFFFF);
        ItemStack is = this.getCurrentOrigin().getDisplayItem();
        context.m_280480_(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(GuiGraphics context, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = this.guiLeft + 176 - border;
        int endY = this.guiTop + 182 - border;
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                context.m_280218_(WINDOW, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean m_6050_(double x, double y, double z) {
        boolean retValue = super.m_6050_(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(GuiGraphics context, int mouseX, int mouseY) {
        int y;
        int textWidth = 128;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        MutableComponent orgDesc = origin.getDescription();
        List descLines = this.f_96547_.m_92923_((FormattedText)orgDesc, textWidth);
        for (FormattedCharSequence formattedCharSequence : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                context.m_280649_(this.f_96547_, formattedCharSequence, x + 2, y - 6, 0xCCCCCC, false);
            }
            y += 12;
        }
        if (this.isOriginRandom) {
            List drawLines = this.f_96547_.m_92923_((FormattedText)this.randomOriginText, textWidth);
            for (FormattedCharSequence line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                context.m_280649_(this.f_96547_, line, x + 2, y, 0xCCCCCC, false);
            }
            y += 14;
        } else {
            for (PowerType powerType : origin.getPowerTypes()) {
                if (powerType.isHidden()) continue;
                FormattedCharSequence name = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)powerType.getName().m_130940_(ChatFormatting.UNDERLINE), textWidth));
                MutableComponent desc = powerType.getDescription();
                List drawLines = this.f_96547_.m_92923_((FormattedText)desc, textWidth);
                if (y >= startY - 24 && y <= endY + 12) {
                    context.m_280649_(this.f_96547_, name, x, y, 0xFFFFFF, false);
                    int tw = this.f_96547_.m_92724_(name);
                    List<Badge> badges = BadgeManager.getPowerBadges(powerType.getIdentifier());
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for (Badge badge : badges) {
                        RenderedBadge renderedBadge = new RenderedBadge(powerType, badge, xStart + 10 * bi, y - 1);
                        this.renderedBadges.add(renderedBadge);
                        context.m_280163_(badge.spriteId(), xStart + 10 * bi, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
                        ++bi;
                    }
                }
                for (FormattedCharSequence line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    context.m_280649_(this.f_96547_, line, x + 2, y, 0xCCCCCC, false);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 14 - (this.guiTop + 158);
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private class RenderedBadge {
        private final PowerType<?> powerType;
        private final Badge badge;
        private final int x;
        private final int y;

        public RenderedBadge(PowerType<?> powerType, Badge badge, int x, int y) {
            this.powerType = powerType;
            this.badge = badge;
            this.x = x;
            this.y = y;
        }

        public boolean hasTooltip() {
            return this.badge.hasTooltip();
        }

        public List<ClientTooltipComponent> getTooltipComponents(Font textRenderer, int widthLimit) {
            return this.badge.getTooltipComponents(this.powerType, widthLimit, OriginDisplayScreen.this.time, textRenderer);
        }
    }
}

