/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.registry.ModComponents;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OriginsEntityConditions {
    public static void register() {
        OriginsEntityConditions.register((ConditionFactory<Entity>)new ConditionFactory(Origins.identifier("origin"), new SerializableData().add("origin", SerializableDataTypes.IDENTIFIER).add("layer", SerializableDataTypes.IDENTIFIER, null), (data, entity) -> {
            if (entity instanceof Player) {
                OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get(entity);
                ResourceLocation originId = data.getId("origin");
                if (data.isPresent("layer")) {
                    ResourceLocation layerId = data.getId("layer");
                    OriginLayer layer = OriginLayers.getLayer(layerId);
                    if (layer == null) {
                        return false;
                    }
                    Origin origin = component.getOrigin(layer);
                    if (origin != null) {
                        return origin.getIdentifier().equals((Object)originId);
                    }
                    return false;
                }
                return component.getOrigins().values().stream().anyMatch(o -> o.getIdentifier().equals((Object)originId));
            }
            return false;
        }));
    }

    private static void register(ConditionFactory<Entity> conditionFactory) {
        Registry.m_122965_((Registry)ApoliRegistries.ENTITY_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

