/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.data.CompatibilityDataTypes;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.registry.ModComponents;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class Origin {
    public static final SerializableData DATA = new SerializableData().add("powers", SerializableDataTypes.IDENTIFIERS, (Object)Lists.newArrayList()).add("icon", CompatibilityDataTypes.ITEM_OR_ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_41852_)).add("unchoosable", SerializableDataTypes.BOOLEAN, (Object)false).add("order", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE).add("impact", OriginsDataTypes.IMPACT, (Object)Impact.NONE).add("loading_priority", SerializableDataTypes.INT, (Object)0).add("upgrades", OriginsDataTypes.UPGRADES, null).add("name", SerializableDataTypes.STRING, (Object)"").add("description", SerializableDataTypes.STRING, (Object)"");
    public static final Origin EMPTY = Origin.register(new Origin(new ResourceLocation("origins", "empty"), new ItemStack((ItemLike)Items.f_41852_), Impact.NONE, -1, Integer.MAX_VALUE).setUnchoosable().setSpecial());
    private ResourceLocation identifier;
    private List<PowerType<?>> powerTypes = new LinkedList();
    private final ItemStack displayItem;
    private final Impact impact;
    private boolean isChoosable;
    private final int order;
    private final int loadingPriority;
    private List<OriginUpgrade> upgrades = new LinkedList<OriginUpgrade>();
    private boolean isSpecial;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public static void init() {
    }

    private static Origin register(Origin origin) {
        return OriginRegistry.register(origin);
    }

    public static HashMap<OriginLayer, Origin> get(Entity entity) {
        if (entity instanceof Player) {
            return Origin.get((Player)entity);
        }
        return new HashMap<OriginLayer, Origin>();
    }

    public static HashMap<OriginLayer, Origin> get(Player player) {
        return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigins();
    }

    public Origin(ResourceLocation id, ItemStack icon, Impact impact, int order, int loadingPriority) {
        this.identifier = id;
        this.displayItem = icon.m_41777_();
        this.impact = impact;
        this.isChoosable = true;
        this.order = order;
        this.loadingPriority = loadingPriority;
    }

    public Origin addUpgrade(OriginUpgrade upgrade) {
        this.upgrades.add(upgrade);
        return this;
    }

    public boolean hasUpgrade() {
        return this.upgrades.size() > 0;
    }

    public Optional<OriginUpgrade> getUpgrade(Advancement advancement) {
        for (OriginUpgrade upgrade : this.upgrades) {
            if (!upgrade.getAdvancementCondition().equals((Object)advancement.m_138327_())) continue;
            return Optional.of(upgrade);
        }
        return Optional.empty();
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Origin add(PowerType<?> ... powerTypes) {
        this.powerTypes.addAll(Lists.newArrayList((Object[])powerTypes));
        return this;
    }

    public void removePowerType(PowerType<?> powerType) {
        this.powerTypes.remove(powerType);
    }

    protected Origin setUnchoosable() {
        this.isChoosable = false;
        return this;
    }

    public Origin setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Origin setName(String name) {
        this.nameTranslationKey = name;
        return this;
    }

    public Origin setDescription(String description) {
        this.descriptionTranslationKey = description;
        return this;
    }

    public boolean hasPowerType(PowerType<?> powerType) {
        if (powerType.getIdentifier() == null) {
            return false;
        }
        if (this.powerTypes.contains(powerType)) {
            return true;
        }
        for (PowerType<?> pt : this.powerTypes) {
            if (!(pt instanceof MultiplePowerType) || !((MultiplePowerType)pt).getSubPowers().contains((Object)powerType.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public int getLoadingPriority() {
        return this.loadingPriority;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public Iterable<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "origin." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".name";
        }
        return this.nameTranslationKey;
    }

    public MutableComponent getName() {
        return Component.m_237115_((String)this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "origin." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)this.getOrCreateDescriptionTranslationKey());
    }

    public int getOrder() {
        return this.order;
    }

    public void write(FriendlyByteBuf buffer) {
        SerializableData.Instance data = new SerializableData.Instance(DATA);
        data.set("icon", (Object)this.displayItem);
        data.set("impact", (Object)this.impact);
        data.set("order", (Object)this.order);
        data.set("loading_priority", (Object)this.loadingPriority);
        data.set("unchoosable", (Object)(!this.isChoosable ? 1 : 0));
        data.set("powers", this.powerTypes.stream().map(PowerType::getIdentifier).collect(Collectors.toList()));
        data.set("name", (Object)this.getOrCreateNameTranslationKey());
        data.set("description", (Object)this.getOrCreateDescriptionTranslationKey());
        data.set("upgrades", this.upgrades);
        DATA.write(buffer, data);
    }

    public static Origin createFromData(ResourceLocation id, SerializableData.Instance data) {
        Origin origin = new Origin(id, (ItemStack)data.get("icon"), (Impact)((Object)data.get("impact")), data.getInt("order"), data.getInt("loading_priority"));
        if (data.getBoolean("unchoosable")) {
            origin.setUnchoosable();
        }
        ((List)data.get("powers")).forEach(powerId -> {
            try {
                PowerType powerType = PowerTypeRegistry.get((ResourceLocation)powerId);
                origin.add(powerType);
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.error("Origin \"" + String.valueOf(id) + "\" contained unregistered power: \"" + String.valueOf(powerId) + "\"");
            }
        });
        if (data.isPresent("upgrades")) {
            ((List)data.get("upgrades")).forEach(origin::addUpgrade);
        }
        origin.setName(data.getString("name"));
        origin.setDescription(data.getString("description"));
        return origin;
    }

    @Environment(value=EnvType.CLIENT)
    public static Origin read(FriendlyByteBuf buffer) {
        ResourceLocation identifier = ResourceLocation.m_135820_((String)buffer.m_130136_(Short.MAX_VALUE));
        return Origin.createFromData(identifier, DATA.read(buffer));
    }

    public static Origin fromJson(ResourceLocation id, JsonObject json) {
        return Origin.createFromData(id, DATA.read(json));
    }

    public String toString() {
        String str = "Origin(" + this.identifier.toString() + ")[";
        for (PowerType<?> pt : this.powerTypes) {
            str = str + String.valueOf(PowerTypeRegistry.getId(pt));
            str = str + ",";
        }
        str = str.substring(0, str.length() - 1) + "]";
        return str;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Origin) {
            return ((Origin)obj).identifier.equals((Object)this.identifier);
        }
        return false;
    }
}

