/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.world.entity.player.Player;

public class ModPacketsC2S {
    public static void register() {
        if (Origins.config.performVersionCheck) {
            ServerLoginConnectionEvents.QUERY_START.register(ModPacketsC2S::handshake);
            ServerLoginNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.HANDSHAKE, ModPacketsC2S::handleHandshakeReply);
        }
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.CHOOSE_ORIGIN, ModPacketsC2S::chooseOrigin);
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.CHOOSE_RANDOM_ORIGIN, ModPacketsC2S::chooseRandomOrigin);
    }

    private static void chooseOrigin(MinecraftServer minecraftServer, ServerPlayer playerEntity, ServerGamePacketListenerImpl serverPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        String originId = packetByteBuf.m_130136_(Short.MAX_VALUE);
        String layerId = packetByteBuf.m_130136_(Short.MAX_VALUE);
        minecraftServer.execute(() -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(ResourceLocation.m_135820_((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                ResourceLocation id = ResourceLocation.m_135820_((String)originId);
                if (id != null) {
                    Origin origin = OriginRegistry.get(id);
                    if (origin.isChoosable() && layer.contains(origin, (Player)playerEntity)) {
                        boolean hadOriginBefore = component.hadOriginBefore();
                        boolean hadAllOrigins = component.hasAllOrigins();
                        component.setOrigin(layer, origin);
                        component.checkAutoChoosingLayers((Player)playerEntity, false);
                        component.sync();
                        if (component.hasAllOrigins() && !hadAllOrigins) {
                            OriginComponent.onChosen((Player)playerEntity, hadOriginBefore);
                        }
                        Origins.LOGGER.info("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " chose Origin: " + originId + ", for layer: " + layerId);
                    } else {
                        Origins.LOGGER.info("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " tried to choose unchoosable Origin for layer " + layerId + ": " + originId + ".");
                        component.setOrigin(layer, Origin.EMPTY);
                    }
                    ModPacketsC2S.confirmOrigin(playerEntity, layer, component.getOrigin(layer));
                    component.selectingOrigin(false);
                    component.sync();
                } else {
                    Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " chose unknown origin: " + originId);
                }
            } else {
                Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void chooseRandomOrigin(MinecraftServer minecraftServer, ServerPlayer playerEntity, ServerGamePacketListenerImpl serverPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        String layerId = packetByteBuf.m_130136_(Short.MAX_VALUE);
        minecraftServer.execute(() -> {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(ResourceLocation.m_135820_((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                List<ResourceLocation> randomOrigins = layer.getRandomOrigins((Player)playerEntity);
                if (layer.isRandomAllowed() && randomOrigins.size() > 0) {
                    ResourceLocation randomOrigin = randomOrigins.get(new Random().nextInt(randomOrigins.size()));
                    Origin origin = OriginRegistry.get(randomOrigin);
                    boolean hadOriginBefore = component.hadOriginBefore();
                    boolean hadAllOrigins = component.hasAllOrigins();
                    component.setOrigin(layer, origin);
                    component.checkAutoChoosingLayers((Player)playerEntity, false);
                    component.sync();
                    if (component.hasAllOrigins() && !hadAllOrigins) {
                        OriginComponent.onChosen((Player)playerEntity, hadOriginBefore);
                    }
                    Origins.LOGGER.info("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " was randomly assigned the following Origin: " + String.valueOf(randomOrigin) + ", for layer: " + layerId);
                } else {
                    Origins.LOGGER.info("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " tried to choose a random Origin for layer " + layerId + ", which is not allowed!");
                    component.setOrigin(layer, Origin.EMPTY);
                }
                ModPacketsC2S.confirmOrigin(playerEntity, layer, component.getOrigin(layer));
                component.selectingOrigin(false);
                component.sync();
            } else {
                Origins.LOGGER.warn("Player " + String.valueOf(playerEntity.m_5446_().m_214077_()) + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void handleHandshakeReply(MinecraftServer minecraftServer, ServerLoginPacketListenerImpl serverLoginNetworkHandler, boolean understood, FriendlyByteBuf packetByteBuf, ServerLoginNetworking.LoginSynchronizer loginSynchronizer, PacketSender packetSender) {
        if (understood) {
            int clientSemVerLength = packetByteBuf.readInt();
            int[] clientSemVer = new int[clientSemVerLength];
            boolean mismatch = clientSemVerLength != Origins.SEMVER.length;
            for (int i = 0; i < clientSemVerLength; ++i) {
                clientSemVer[i] = packetByteBuf.readInt();
                if (i >= clientSemVerLength - 1 || clientSemVer[i] == Origins.SEMVER[i]) continue;
                mismatch = true;
            }
            if (mismatch) {
                StringBuilder clientVersionString = new StringBuilder();
                for (int i = 0; i < clientSemVerLength; ++i) {
                    clientVersionString.append(clientSemVer[i]);
                    if (i >= clientSemVerLength - 1) continue;
                    clientVersionString.append(".");
                }
                serverLoginNetworkHandler.m_10053_((Component)Component.m_237110_((String)"origins.gui.version_mismatch", (Object[])new Object[]{Origins.VERSION, clientVersionString}));
            }
        } else {
            serverLoginNetworkHandler.m_10053_(Component.m_130674_((String)("This server requires you to install the Origins mod (v" + Origins.VERSION + ") to play.")));
        }
    }

    private static void handshake(ServerLoginPacketListenerImpl serverLoginNetworkHandler, MinecraftServer minecraftServer, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer loginSynchronizer) {
        packetSender.sendPacket(ModPackets.HANDSHAKE, PacketByteBufs.empty());
    }

    private static void confirmOrigin(ServerPlayer player, OriginLayer layer, Origin origin) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.m_130085_(layer.getIdentifier());
        buf.m_130085_(origin.getIdentifier());
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.CONFIRM_ORIGIN, (FriendlyByteBuf)buf);
    }
}

