/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class LoginMixin {
    @Shadow
    public abstract List<ServerPlayer> m_11314_();

    @Inject(at={@At(value="TAIL")}, method={"onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;)V"})
    private void openOriginsGui(Connection connection, ServerPlayer player, CallbackInfo info) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        FriendlyByteBuf originListData = new FriendlyByteBuf(Unpooled.buffer());
        originListData.writeInt(OriginRegistry.size() - 1);
        OriginRegistry.entries().forEach(entry -> {
            if (entry.getValue() != Origin.EMPTY) {
                originListData.m_130085_((ResourceLocation)entry.getKey());
                ((Origin)entry.getValue()).write(originListData);
            }
        });
        FriendlyByteBuf originLayerData = new FriendlyByteBuf(Unpooled.buffer());
        originLayerData.writeInt(OriginLayers.size());
        OriginLayers.getLayers().forEach(layer -> {
            layer.write(originLayerData);
            if (layer.isEnabled() && !component.hasOrigin((OriginLayer)layer)) {
                component.setOrigin((OriginLayer)layer, Origin.EMPTY);
            }
        });
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.ORIGIN_LIST, (FriendlyByteBuf)originListData);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.LAYER_LIST, (FriendlyByteBuf)originLayerData);
        BadgeManager.sync(player);
        List<ServerPlayer> playerList = this.m_11314_();
        playerList.forEach(spe -> ModComponents.ORIGIN.syncWith(spe, (ComponentProvider)player));
        OriginComponent.sync((Player)player);
        if (!component.hasAllOrigins()) {
            if (component.checkAutoChoosingLayers((Player)player, true)) {
                component.sync();
            }
            if (component.hasAllOrigins()) {
                OriginComponent.onChosen((Player)player, false);
            } else {
                FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
                data.writeBoolean(true);
                ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (FriendlyByteBuf)data);
            }
        }
    }
}

