/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.content;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OrbOfOriginItem
extends Item {
    public OrbOfOriginItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (!world.f_46443_) {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)user);
            Map<OriginLayer, Origin> targets = this.getTargets(stack);
            if (!targets.isEmpty()) {
                for (Map.Entry entry : targets.entrySet()) {
                    component.setOrigin((OriginLayer)entry.getKey(), (Origin)entry.getValue());
                }
            } else {
                for (OriginLayer originLayer : OriginLayers.getLayers()) {
                    if (!originLayer.isEnabled()) continue;
                    component.setOrigin(originLayer, Origin.EMPTY);
                }
            }
            component.selectingOrigin(true);
            component.checkAutoChoosingLayers(user, false);
            component.sync();
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            data.writeBoolean(false);
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)user), (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (FriendlyByteBuf)data);
        }
        if (!user.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        Map<OriginLayer, Origin> targets = this.getTargets(stack);
        for (Map.Entry<OriginLayer, Origin> target : targets.entrySet()) {
            if (target.getValue() == Origin.EMPTY) {
                tooltip.add((Component)Component.m_237110_((String)"item.origins.orb_of_origin.layer_generic", (Object[])new Object[]{Component.m_237115_((String)target.getKey().getTranslationKey())}).m_130940_(ChatFormatting.GRAY));
                continue;
            }
            tooltip.add((Component)Component.m_237110_((String)"item.origins.orb_of_origin.layer_specific", (Object[])new Object[]{Component.m_237115_((String)target.getKey().getTranslationKey()), target.getValue().getName()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private Map<OriginLayer, Origin> getTargets(ItemStack stack) {
        ListTag targetsNbt;
        HashMap<OriginLayer, Origin> targets = new HashMap<OriginLayer, Origin>();
        CompoundTag stackNbt = stack.m_41783_();
        ListTag listTag = targetsNbt = stackNbt == null ? new ListTag() : stackNbt.m_128437_("Targets", 10);
        if (targetsNbt.isEmpty()) {
            return targets;
        }
        for (Tag nbtElement : targetsNbt) {
            try {
                CompoundTag targetNbt = (CompoundTag)nbtElement;
                ResourceLocation layerId = new ResourceLocation(targetNbt.m_128461_("Layer"));
                OriginLayer layer = OriginLayers.getLayer(layerId);
                Origin origin = Origin.EMPTY;
                if (targetNbt.m_128425_("Origin", 8)) {
                    ResourceLocation originId = new ResourceLocation(targetNbt.m_128461_("Origin"));
                    origin = OriginRegistry.get(originId);
                }
                if (!layer.isEnabled() || !layer.contains(origin) && !origin.isSpecial()) continue;
                targets.put(layer, origin);
            }
            catch (Exception exception) {}
        }
        return targets;
    }
}

