/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerOriginComponent
implements OriginComponent {
    private final HashMap<OriginLayer, Origin> origins = new HashMap();
    private final Player player;
    private boolean selectingOrigin = false;
    private boolean hadOriginBefore = false;
    private int invulnerabilityTicks = 0;

    public PlayerOriginComponent(Player player) {
        this.player = player;
    }

    @Override
    public boolean hasSelectionInvulnerability() {
        return this.invulnerabilityTicks > 0;
    }

    @Override
    public boolean isSelectingOrigin() {
        return this.selectingOrigin;
    }

    @Override
    public void selectingOrigin(boolean selectingOrigin) {
        this.selectingOrigin = selectingOrigin;
        if (selectingOrigin) {
            this.invulnerabilityTicks = 60;
        }
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayers.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins().isEmpty() || this.origins.containsKey(layer) && this.origins.get(layer) != Origin.EMPTY);
    }

    @Override
    public HashMap<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        Player player;
        Origin oldOrigin = this.getOrigin(layer);
        if (origin == oldOrigin) {
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.grantPowersFromOrigin(origin, powerComponent);
        this.origins.put(layer, origin);
        if (oldOrigin != null && !origin.getIdentifier().equals((Object)oldOrigin.getIdentifier())) {
            powerComponent.removeAllPowersFromSource(oldOrigin.getIdentifier());
        }
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            ChoseOriginCriterion.INSTANCE.trigger(spe, origin);
        }
    }

    private void grantPowersFromOrigin(Origin origin, PowerHolderComponent powerComponent) {
        ResourceLocation source = origin.getIdentifier();
        for (PowerType<?> powerType : origin.getPowerTypes()) {
            if (powerComponent.hasPower(powerType, source)) continue;
            powerComponent.addPower(powerType, source);
        }
    }

    private void revokeRemovedPowers(Origin origin, PowerHolderComponent powerComponent) {
        ResourceLocation sourceId = origin.getIdentifier();
        powerComponent.getPowersFromSource(sourceId).stream().filter(pt -> !origin.hasPowerType((PowerType<?>)pt)).forEach(pt -> powerComponent.removePower(pt, sourceId));
    }

    public void tick() {
        if (!this.selectingOrigin && this.invulnerabilityTicks > 0) {
            --this.invulnerabilityTicks;
        }
    }

    public void readFromNbt(@NotNull CompoundTag compoundTag) {
        int i;
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in PlayerOriginComponent#fromTag! This is not supposed to happen D:");
            return;
        }
        PowerHolderComponent powerComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
        this.origins.clear();
        if (compoundTag.m_128441_("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayers.getLayer(Origins.identifier("origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(new ResourceLocation(compoundTag.m_128461_("Origin"))));
            }
            catch (Exception ignored) {
                Origins.LOGGER.warn("Player {} had old origin which could not be migrated: {}", (Object)this.player.m_7755_().getString(), (Object)compoundTag.m_128461_("Origin"));
            }
        } else {
            ListTag originLayersNbt = compoundTag.m_128437_("OriginLayers", 10);
            for (i = 0; i < originLayersNbt.size(); ++i) {
                CompoundTag originLayerNbt = originLayersNbt.m_128728_(i);
                try {
                    ResourceLocation layerId = new ResourceLocation(originLayerNbt.m_128461_("Layer"));
                    ResourceLocation originId = new ResourceLocation(originLayerNbt.m_128461_("Origin"));
                    OriginLayer layer = OriginLayers.getLayer(layerId);
                    Origin origin = OriginRegistry.get(originId);
                    this.origins.put(layer, origin);
                    if (layer.contains(origin) || origin.isSpecial()) continue;
                    Origins.LOGGER.warn("Origin \"{}\" is not in origin layer \"{}\" and is not considered special, but was found on player {}!", (Object)originId, (Object)layerId, (Object)this.player.m_7755_().getString());
                    powerComponent.removeAllPowersFromSource(originId);
                    this.origins.put(layer, Origin.EMPTY);
                    continue;
                }
                catch (Exception e) {
                    Origins.LOGGER.error("There was a problem trying to read origin NBT data of player {}: {}", (Object)this.player.m_7755_().getString(), (Object)e.getMessage());
                }
            }
        }
        this.selectingOrigin = compoundTag.m_128471_("SelectingOrigin");
        this.hadOriginBefore = compoundTag.m_128471_("HadOriginBefore");
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        for (Origin origin : this.origins.values()) {
            this.grantPowersFromOrigin(origin, powerComponent);
        }
        for (Origin origin : this.origins.values()) {
            this.revokeRemovedPowers(origin, powerComponent);
        }
        if (!compoundTag.m_128441_("Powers")) {
            return;
        }
        ListTag legacyPowersNbt = compoundTag.m_128437_("Powers", 10);
        for (i = 0; i < legacyPowersNbt.size(); ++i) {
            CompoundTag legacyPowerNbt = legacyPowersNbt.m_128728_(i);
            String legacyPowerString = legacyPowerNbt.m_128461_("Type");
            try {
                ResourceLocation legacyPowerId = new ResourceLocation(legacyPowerString);
                PowerType legacyPowerType = PowerTypeRegistry.get((ResourceLocation)legacyPowerId);
                if (!powerComponent.hasPower(legacyPowerType)) continue;
                try {
                    Tag legacyPowerData = legacyPowerNbt.m_128423_("Data");
                    powerComponent.getPower(legacyPowerType).fromTag(legacyPowerData);
                }
                catch (ClassCastException e) {
                    Origins.LOGGER.warn("Data type of power \"{}\" changed, skipping data for that power on entity {}", (Object)legacyPowerId, (Object)this.player.m_7755_().getString());
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Power data of unregistered power \"{}\" found on player {}, skipping...", (Object)legacyPowerString, (Object)this.player.m_7755_().getString());
            }
        }
    }

    public void writeToNbt(@NotNull CompoundTag compoundTag) {
        ListTag originLayersNbt = new ListTag();
        this.origins.forEach((layer, origin) -> {
            CompoundTag originLayerNbt = new CompoundTag();
            originLayerNbt.m_128359_("Layer", layer.getIdentifier().toString());
            originLayerNbt.m_128359_("Origin", origin.getIdentifier().toString());
            originLayersNbt.add((Object)originLayerNbt);
        });
        compoundTag.m_128365_("OriginLayers", (Tag)originLayersNbt);
        compoundTag.m_128379_("SelectingOrigin", this.selectingOrigin);
        compoundTag.m_128379_("HadOriginBefore", this.hadOriginBefore);
    }

    @Override
    public void sync() {
        OriginComponent.sync(this.player);
    }
}

