/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class OriginArgumentType
implements ArgumentType<ResourceLocation> {
    public static final DynamicCommandExceptionType ORIGIN_NOT_FOUND = new DynamicCommandExceptionType(o -> Component.m_237110_((String)"commands.origin.origin_not_found", (Object[])new Object[]{o}));

    public static OriginArgumentType origin() {
        return new OriginArgumentType();
    }

    public ResourceLocation parse(StringReader stringReader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)stringReader);
    }

    public static Origin getOrigin(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
        ResourceLocation id = (ResourceLocation)context.getArgument(argumentName, ResourceLocation.class);
        try {
            return OriginRegistry.get(id);
        }
        catch (IllegalArgumentException e) {
            throw ORIGIN_NOT_FOUND.create((Object)id);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<ResourceLocation> availableOrigins = new ArrayList<ResourceLocation>();
        try {
            ResourceLocation originLayerId = (ResourceLocation)context.getArgument("layer", ResourceLocation.class);
            OriginLayer originLayer = OriginLayers.getLayer(originLayerId);
            availableOrigins.add(Origin.EMPTY.getIdentifier());
            if (originLayer != null) {
                availableOrigins.addAll(originLayer.getOrigins());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return SharedSuggestionProvider.m_82957_(availableOrigins.stream(), (SuggestionsBuilder)builder);
    }
}

