/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.util.PowerKeyManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public record KeybindBadge(ResourceLocation spriteId, String text) implements Badge
{
    public KeybindBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"), (String)instance.get("text"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public static void addLines(List<ClientTooltipComponent> tooltips, Component text, Font textRenderer, int widthLimit) {
        if (textRenderer.m_92852_((FormattedText)text) > widthLimit) {
            for (FormattedCharSequence orderedText : textRenderer.m_92923_((FormattedText)text, widthLimit)) {
                tooltips.add((ClientTooltipComponent)new ClientTextTooltip(orderedText));
            }
        } else {
            tooltips.add((ClientTooltipComponent)new ClientTextTooltip(text.m_7532_()));
        }
    }

    @Override
    public List<ClientTooltipComponent> getTooltipComponents(PowerType<?> powerType, int widthLimit, float time, Font textRenderer) {
        LinkedList<ClientTooltipComponent> tooltips = new LinkedList<ClientTooltipComponent>();
        MutableComponent keyText = ((MutableComponent)Component.m_130674_((String)"[")).m_7220_((Component)KeyMapping.m_90842_((String)PowerKeyManager.getKeyIdentifier(powerType.getIdentifier())).get()).m_7220_(Component.m_130674_((String)"]"));
        KeybindBadge.addLines(tooltips, (Component)Component.m_237110_((String)this.text, (Object[])new Object[]{keyText}), textRenderer, widthLimit);
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId);
        instance.set("text", (Object)this.text);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return BadgeFactories.KEYBIND;
    }
}

