/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PrePowerReloadCallback;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PowerTypes;
import io.github.apace100.apoli.power.RecipePower;
import io.github.apace100.apoli.power.ToggleNightVisionPower;
import io.github.apace100.apoli.power.TogglePower;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.registry.DataObjectRegistry;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.CraftingRecipeBadge;
import io.github.apace100.origins.badge.KeybindBadge;
import io.github.apace100.origins.integration.AutoBadgeCallback;
import io.github.apace100.origins.networking.ModPackets;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public final class BadgeManager {
    public static final DataObjectRegistry<Badge> REGISTRY = new DataObjectRegistry.Builder(Origins.identifier("badge"), Badge.class).readFromData("badges", true).dataErrorHandler((id, exception) -> Origins.LOGGER.error("Failed to read badge " + String.valueOf(id) + ", caused by", (Throwable)exception)).defaultFactory((DataObjectFactory)BadgeFactories.KEYBIND).buildAndRegister();
    private static final Map<ResourceLocation, List<Badge>> BADGES = new HashMap<ResourceLocation, List<Badge>>();
    private static final ResourceLocation TOGGLE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/toggle.png");
    private static final ResourceLocation ACTIVE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/active.png");
    private static final ResourceLocation RECIPE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/recipe.png");
    private static final ResourceLocation TOGGLE_BADGE_ID = Origins.identifier("toggle");
    private static final ResourceLocation ACTIVE_BADGE_ID = Origins.identifier("active");

    public static void init() {
        BadgeManager.register(BadgeFactories.SPRITE);
        BadgeManager.register(BadgeFactories.TOOLTIP);
        BadgeManager.register(BadgeFactories.CRAFTING_RECIPE);
        BadgeManager.register(BadgeFactories.KEYBIND);
        PrePowerReloadCallback.EVENT.register(BadgeManager::clear);
        PowerTypes.registerAdditionalData((String)"badges", BadgeManager::readCustomBadges);
        PostPowerLoadCallback.EVENT.register(BadgeManager::readAutoBadges);
        AutoBadgeCallback.EVENT.register(BadgeManager::createAutoBadges);
    }

    public static void register(BadgeFactory factory) {
        REGISTRY.registerFactory(factory.id(), (DataObjectFactory)factory);
    }

    public static void putPowerBadge(ResourceLocation powerId, Badge badge) {
        List badgeList = BADGES.computeIfAbsent(powerId, id -> new LinkedList());
        badgeList.add(badge);
    }

    public static List<Badge> getPowerBadges(ResourceLocation powerId) {
        return BADGES.computeIfAbsent(powerId, id -> new LinkedList());
    }

    public static void clear() {
        BADGES.clear();
    }

    public static void sync(ServerPlayer player) {
        REGISTRY.sync(player);
        FriendlyByteBuf badgeData = new FriendlyByteBuf(Unpooled.buffer());
        badgeData.writeInt(BADGES.size());
        BADGES.forEach((id, list) -> {
            badgeData.m_130085_(id);
            badgeData.writeInt(list.size());
            list.forEach(badge -> badge.writeBuf(badgeData));
        });
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.BADGE_LIST, (FriendlyByteBuf)badgeData);
    }

    public static void readCustomBadges(ResourceLocation powerId, ResourceLocation factoryId, boolean isSubPower, JsonElement data, PowerType<?> powerType) {
        if (!powerType.isHidden() && !isSubPower) {
            if (data.isJsonArray()) {
                BADGES.computeIfAbsent(powerId, id -> new LinkedList());
                for (JsonElement badgeJson : data.getAsJsonArray()) {
                    if (badgeJson.isJsonPrimitive()) {
                        ResourceLocation badgeId = ResourceLocation.m_135820_((String)badgeJson.getAsString());
                        if (badgeId != null) {
                            Badge badge = (Badge)REGISTRY.get(badgeId);
                            if (badge != null) {
                                BadgeManager.putPowerBadge(powerId, badge);
                                continue;
                            }
                            Origins.LOGGER.error("\"badges\" field in power \"{}\" is referring to an undefined badge \"{}\"!", (Object)powerId, (Object)badgeId);
                            continue;
                        }
                        Origins.LOGGER.error("\"badges\" field in power \"{}\" is not a valid identifier!", (Object)powerId);
                        continue;
                    }
                    if (badgeJson.isJsonObject()) {
                        try {
                            BadgeManager.putPowerBadge(powerId, (Badge)REGISTRY.readDataObject(badgeJson));
                        }
                        catch (Exception exception) {
                            Origins.LOGGER.error("\"badges\" field in power \"" + String.valueOf(powerId) + "\" contained an JSON object entry that cannot be resolved!", (Throwable)exception);
                        }
                        continue;
                    }
                    Origins.LOGGER.error("\"badges\" field in power \"" + String.valueOf(powerId) + "\" contained an entry that was a JSON array, which is not allowed!");
                }
            } else {
                Origins.LOGGER.error("\"badges\" field in power \"" + String.valueOf(powerId) + "\" should be an array.");
            }
        }
    }

    public static void readAutoBadges(ResourceLocation powerId, ResourceLocation factoryId, boolean isSubPower, JsonObject json, PowerType<?> powerType) {
        if (BADGES.containsKey(powerId) || powerType.isHidden() || isSubPower) {
            return;
        }
        if (powerType instanceof MultiplePowerType) {
            MultiplePowerType mp = (MultiplePowerType)powerType;
            List badgeList = BADGES.computeIfAbsent(powerId, id -> new LinkedList());
            mp.getSubPowers().stream().map(PowerTypeRegistry::get).forEach(subPowerType -> ((AutoBadgeCallback)AutoBadgeCallback.EVENT.invoker()).createAutoBadge(subPowerType.getIdentifier(), (PowerType<?>)subPowerType, badgeList));
        } else {
            ((AutoBadgeCallback)AutoBadgeCallback.EVENT.invoker()).createAutoBadge(powerId, powerType, BADGES.computeIfAbsent(powerId, id -> new LinkedList()));
        }
    }

    public static void createAutoBadges(ResourceLocation powerId, PowerType<?> powerType, List<Badge> badgeList) {
        Power power = powerType.create(null);
        if (power instanceof Active) {
            ResourceLocation autoBadgeId;
            Active active = (Active)power;
            boolean toggle = active instanceof TogglePower || active instanceof ToggleNightVisionPower;
            ResourceLocation resourceLocation = autoBadgeId = toggle ? TOGGLE_BADGE_ID : ACTIVE_BADGE_ID;
            if (REGISTRY.containsId(autoBadgeId)) {
                badgeList.add((Badge)REGISTRY.get(autoBadgeId));
            } else {
                badgeList.add(new KeybindBadge(toggle ? TOGGLE_BADGE_SPRITE : ACTIVE_BADGE_SPRITE, toggle ? "origins.gui.badge.toggle" : "origins.gui.badge.active"));
            }
        } else if (power instanceof RecipePower) {
            RecipePower recipePower = (RecipePower)power;
            Recipe recipe = recipePower.getRecipe();
            String type = recipe instanceof ShapedRecipe ? "shaped" : "shapeless";
            badgeList.add(new CraftingRecipeBadge(RECIPE_BADGE_SPRITE, (Recipe<TransientCraftingContainer>)recipe, (Component)Component.m_237115_((String)("origins.gui.badge.recipe.crafting." + type)), null));
        }
    }
}

