/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypes;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.calio.mixin.CriteriaRegistryInvoker;
import io.github.apace100.calio.resource.OrderedResourceListenerInitializer;
import io.github.apace100.calio.resource.OrderedResourceListenerManager;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPacketsC2S;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.OriginsEntityConditions;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModEnchantments;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.registry.ModLoot;
import io.github.apace100.origins.registry.ModTags;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import io.github.apace100.origins.util.OriginsJsonConfigSerializer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins
implements ModInitializer,
OrderedResourceListenerInitializer {
    public static final String MODID = "origins";
    public static String VERSION = "";
    public static int[] SEMVER;
    public static final Logger LOGGER;
    public static ServerConfig config;
    private static ConfigSerializer<ServerConfig> configSerializer;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                Origins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        LOGGER.info("Origins " + VERSION + " is initializing. Have fun!");
        AutoConfig.register(ServerConfig.class, (definition, configClass) -> {
            configSerializer = new OriginsJsonConfigSerializer(definition, configClass, new OriginsConfigSerializer(definition, configClass));
            return configSerializer;
        });
        config = (ServerConfig)AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        NamespaceAlias.addAlias((String)MODID, (String)"apoli");
        OriginsPowerTypes.register();
        OriginsEntityConditions.register();
        ModBlocks.register();
        ModItems.register();
        ModTags.register();
        ModPacketsC2S.register();
        ModEnchantments.register();
        ModEntities.register();
        ModLoot.registerLootTables();
        Origin.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> OriginCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.f_256869_).register(content -> content.m_246326_((ItemLike)ModItems.ORB_OF_ORIGIN));
        CriteriaRegistryInvoker.callRegister((CriterionTrigger)ChoseOriginCriterion.INSTANCE);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ((OriginComponent)ModComponents.ORIGIN.get((Object)handler.f_9743_)).selectingOrigin(false));
    }

    public static void serializeConfig() {
        try {
            configSerializer.serialize((ConfigData)config);
        }
        catch (ConfigSerializer.SerializationException e) {
            LOGGER.error("Failed serialization of config file: " + e.getMessage());
        }
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void registerResourceListeners(OrderedResourceListenerManager manager) {
        ResourceLocation powerData = Apoli.identifier((String)"powers");
        ResourceLocation originData = Origins.identifier(MODID);
        OriginManager originLoader = new OriginManager();
        manager.register(PackType.SERVER_DATA, (IdentifiableResourceReloadListener)originLoader).after(powerData).complete();
        manager.register(PackType.SERVER_DATA, (IdentifiableResourceReloadListener)new OriginLayers()).after(originData).complete();
        BadgeManager.init();
        IdentifiableResourceReloadListener badgeLoader = BadgeManager.REGISTRY.getLoader();
        manager.register(PackType.SERVER_DATA, badgeLoader).before(powerData).complete();
        PowerTypes.DEPENDENCIES.add(badgeLoader.getFabricId());
    }

    static {
        LOGGER = LogManager.getLogger(Origins.class);
    }

    @Config(name="origins_server")
    public static class ServerConfig
    implements ConfigData {
        public boolean performVersionCheck = true;
        public JsonObject origins = new JsonObject();

        public boolean isOriginDisabled(ResourceLocation originId) {
            String idString = originId.toString();
            if (!this.origins.has(idString)) {
                return false;
            }
            JsonElement element = this.origins.get(idString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !GsonHelper.m_13855_((JsonObject)jsonObject, (String)"enabled", (boolean)true);
            }
            return false;
        }

        public boolean isPowerDisabled(ResourceLocation originId, ResourceLocation powerId) {
            String originIdString = originId.toString();
            if (!this.origins.has(originIdString)) {
                return false;
            }
            String powerIdString = powerId.toString();
            JsonElement element = this.origins.get(originIdString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !GsonHelper.m_13855_((JsonObject)jsonObject, (String)powerIdString, (boolean)true);
            }
            return false;
        }

        public boolean addToConfig(Origin origin) {
            JsonObject originObj;
            boolean changed = false;
            String originIdString = origin.getIdentifier().toString();
            if (!this.origins.has(originIdString) || !(this.origins.get(originIdString) instanceof JsonObject)) {
                originObj = new JsonObject();
                this.origins.add(originIdString, (JsonElement)originObj);
                changed = true;
            } else {
                originObj = (JsonObject)this.origins.get(originIdString);
            }
            if (!originObj.has("enabled") || !(originObj.get("enabled") instanceof JsonPrimitive)) {
                originObj.addProperty("enabled", Boolean.TRUE);
                changed = true;
            }
            for (PowerType<?> power : origin.getPowerTypes()) {
                String powerIdString = power.getIdentifier().toString();
                if (originObj.has(powerIdString) && originObj.get(powerIdString) instanceof JsonPrimitive) continue;
                originObj.addProperty(powerIdString, Boolean.TRUE);
                changed = true;
            }
            return changed;
        }
    }
}

