/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.other;

import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.registry.BlueprintHolderSets;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class WoodworksStructureRepaletters {
    public static void bootstrap(BootstapContext<StructureRepaletterEntry> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.chestConfig(), "oak_chests_in_villages", Blocks.f_50087_, (Block)WoodworksBlocks.OAK_CHEST.get(), BuiltinStructures.f_209864_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.chestConfig(), "spruce_chests_in_villages", Blocks.f_50087_, (Block)WoodworksBlocks.SPRUCE_CHEST.get(), BuiltinStructures.f_209868_, BuiltinStructures.f_209867_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.chestConfig(), "jungle_chests_in_villages", Blocks.f_50087_, (Block)WoodworksBlocks.JUNGLE_CHEST.get(), BuiltinStructures.f_209865_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.chestConfig(), "acacia_chests_in_villages", Blocks.f_50087_, (Block)WoodworksBlocks.ACACIA_CHEST.get(), BuiltinStructures.f_209866_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.bookshelfConfig(), "spruce_bookshelves_in_villages", Blocks.f_50078_, (Block)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), BuiltinStructures.f_209868_, BuiltinStructures.f_209867_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.bookshelfConfig(), "jungle_bookshelves_in_villages", Blocks.f_50078_, (Block)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), BuiltinStructures.f_209865_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.bookshelfConfig(), "acacia_bookshelves_in_villages", Blocks.f_50078_, (Block)WoodworksBlocks.ACACIA_BOOKSHELF.get(), BuiltinStructures.f_209866_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.ladderConfig(), "spruce_ladders_in_villages", Blocks.f_50155_, (Block)WoodworksBlocks.SPRUCE_LADDER.get(), BuiltinStructures.f_209868_, BuiltinStructures.f_209867_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.ladderConfig(), "jungle_ladders_in_villages", Blocks.f_50155_, (Block)WoodworksBlocks.JUNGLE_LADDER.get(), BuiltinStructures.f_209865_);
        WoodworksStructureRepaletters.basicRepaletter(context, (HolderGetter<Structure>)structures, WoodworksStructureRepaletters.ladderConfig(), "acacia_ladders_in_villages", Blocks.f_50155_, (Block)WoodworksBlocks.ACACIA_LADDER.get(), BuiltinStructures.f_209866_);
    }

    @SafeVarargs
    private static void basicRepaletter(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith, ResourceKey<Structure> ... selector) {
        context.m_255272_(WoodworksStructureRepaletters.repaletterKey(name), (Object)new StructureRepaletterEntry((HolderSet)BlueprintHolderSets.conditional((HolderSet)HolderSet.m_205800_(Stream.of(selector).map(arg_0 -> structures.m_255043_(arg_0)).collect(Collectors.toList())), (ICondition[])new ICondition[]{condition}), Optional.empty(), false, (StructureRepaletter)new SimpleStructureRepaletter(replacesBlock, replacesWith)));
    }

    private static ICondition bookshelfConfig() {
        return WoodworksStructureRepaletters.configCondition(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", WoodworksConfig.COMMON.woodenBookshelvesInVillages, "wooden_bookshelves_in_villages");
    }

    private static ICondition ladderConfig() {
        return WoodworksStructureRepaletters.configCondition(WoodworksConfig.COMMON.woodenLadders, "wooden_ladders", WoodworksConfig.COMMON.woodenLaddersInVillages, "wooden_ladders_in_villages");
    }

    private static ICondition chestConfig() {
        return WoodworksStructureRepaletters.configCondition(WoodworksConfig.COMMON.woodenChests, "wooden_chests", WoodworksConfig.COMMON.woodenChestsInVillages, "wooden_chests_in_villages");
    }

    private static ICondition configCondition(ForgeConfigSpec.ConfigValue<?> value1, String key1, ForgeConfigSpec.ConfigValue<?> value2, String key2) {
        return new AndCondition(new ICondition[]{WoodworksRecipeProvider.config(value1, key1), WoodworksRecipeProvider.config(value2, key2)});
    }

    private static ResourceKey<StructureRepaletterEntry> repaletterKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)BlueprintDataPackRegistries.STRUCTURE_REPALETTERS, (ResourceLocation)new ResourceLocation("woodworks", name));
    }
}

