/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.inventory;

import com.google.common.collect.Lists;
import com.teamabnormals.woodworks.common.item.crafting.SawmillRecipe;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import com.teamabnormals.woodworks.core.registry.WoodworksMenuTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksRecipes;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SawmillMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<SawmillRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            SawmillMenu.this.m_6199_((Container)this);
            SawmillMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public SawmillMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public SawmillMenu(int id, Inventory p_40298_, final ContainerLevelAccess access) {
        super((MenuType)WoodworksMenuTypes.SAWMILL.get(), id);
        this.access = access;
        this.level = p_40298_.f_35978_.m_9236_();
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                SawmillMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack input = SawmillMenu.this.inputSlot.m_6201_(1);
                if (!input.m_41619_()) {
                    SawmillMenu.this.setupResultSlot();
                }
                access.m_39292_((level, pos) -> {
                    long time = level.m_46467_();
                    if (SawmillMenu.this.lastSoundTime != time) {
                        level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        SawmillMenu.this.lastSoundTime = time;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(SawmillMenu.this.inputSlot.m_7993_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)p_40298_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)p_40298_, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<SawmillRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return SawmillMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)WoodworksBlocks.SAWMILL.get()));
    }

    public boolean m_6366_(Player player, int index) {
        if (this.isValidRecipeIndex(index)) {
            this.selectedRecipeIndex.m_6422_(index);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_40335_) {
        return p_40335_ >= 0 && p_40335_ < this.recipes.size();
    }

    public void m_6199_(Container container) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (!itemstack.m_150930_(this.input.m_41720_())) {
            this.input = itemstack.m_41777_();
            this.setupRecipeList(container, itemstack);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)WoodworksRecipes.WoodworksRecipeTypes.SAWING.get(), container, this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            SawmillRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack stack = recipe.m_5874_(this.container, this.level.m_9598_());
            if (stack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)recipe);
                this.resultSlot.m_5852_(stack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)WoodworksMenuTypes.SAWMILL.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack input = slot.m_7993_();
            Item item = input.m_41720_();
            stack = input.m_41777_();
            if (index == 1) {
                item.m_7836_(input, player.m_9236_(), player);
                if (!this.m_38903_(input, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(input, stack);
            } else if (index == 0 ? !this.m_38903_(input, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)WoodworksRecipes.WoodworksRecipeTypes.SAWING.get(), (Container)new SimpleContainer(new ItemStack[]{input}), this.level).isPresent() ? !this.m_38903_(input, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(input, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(input, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (input.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (input.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, input);
            this.m_38946_();
        }
        return stack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(player, this.container));
    }
}

