/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base.asm;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.internal.base.ComponentRegistrationInitializer;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.asm.CcaAsmHelper;
import dev.onyxstudios.cca.internal.base.asm.CcaBootstrap;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public abstract class StaticComponentPluginBase<T, I>
extends LazyDispatcher {
    private final ComponentContainer.Factory.Builder<T> containerFactoryBuilder;

    protected StaticComponentPluginBase(String likelyInitTrigger, Class<T> providerClass) {
        super(likelyInitTrigger);
        this.containerFactoryBuilder = ComponentContainer.Factory.builder(providerClass);
    }

    public static <I> Class<? extends I> spinContainerFactory(String implNameSuffix, Class<? super I> containerFactoryType, Class<? extends ComponentContainer> containerImpl, List<Class<?>> actualFactoryParams) throws IOException {
        CcaBootstrap.INSTANCE.ensureInitialized();
        CcaAsmHelper.checkValidJavaIdentifier(implNameSuffix);
        Object[] constructors = containerImpl.getConstructors();
        if (constructors.length != 1) {
            throw new IllegalStateException("Ambiguous constructor declarations in " + containerImpl + ": " + Arrays.toString(constructors));
        }
        Method factorySam = CcaAsmHelper.findSam(containerFactoryType);
        if (factorySam.getParameterCount() != actualFactoryParams.size()) {
            throw new IllegalArgumentException("Actual argument list length mismatches with factory SAM: " + actualFactoryParams + " and " + factorySam);
        }
        if (((Constructor)constructors[0]).getParameterCount() != factorySam.getParameterCount()) {
            throw new IllegalArgumentException("Factory SAM parameter count should be the same as container constructor (found " + factorySam + " for " + (Constructor)constructors[0] + ")");
        }
        Class<?>[] factoryParamClasses = factorySam.getParameterTypes();
        Type[] factoryArgs = new Type[factoryParamClasses.length];
        for (int i = 0; i < factoryParamClasses.length; ++i) {
            if (!factoryParamClasses[i].isAssignableFrom(actualFactoryParams.get(i))) {
                throw new IllegalArgumentException("Container factory parameter %s is not assignable from specified actual parameter %s(%s, %s)".formatted(factoryParamClasses[i].getSimpleName(), actualFactoryParams.get(i).getSimpleName(), factorySam, actualFactoryParams));
            }
            factoryArgs[i] = Type.getType(factoryParamClasses[i]);
        }
        String containerCtorDesc = Type.getConstructorDescriptor((Constructor)constructors[0]);
        String containerImplName = Type.getInternalName(containerImpl);
        ClassNode containerFactoryWriter = new ClassNode(393216);
        String factoryImplName = "dev/onyxstudios/cca/_generated_/GeneratedContainerFactory_" + implNameSuffix;
        containerFactoryWriter.visit(52, 17, factoryImplName, null, "java/lang/Object", new String[]{Type.getInternalName(containerFactoryType)});
        MethodVisitor init = containerFactoryWriter.visitMethod(1, "<init>", "()V", null, null);
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        init.visitInsn(177);
        init.visitEnd();
        MethodVisitor createContainer = containerFactoryWriter.visitMethod(1, factorySam.getName(), Type.getMethodDescriptor((Method)factorySam), null, null);
        createContainer.visitTypeInsn(187, containerImplName);
        createContainer.visitInsn(89);
        for (int i = 0; i < actualFactoryParams.size(); ++i) {
            createContainer.visitVarInsn(factoryArgs[i].getOpcode(21), i + 1);
            if (factoryArgs[i].getSort() != 10 && factoryArgs[i].getSort() != 9) continue;
            createContainer.visitTypeInsn(192, Type.getInternalName(actualFactoryParams.get(i)));
        }
        createContainer.visitMethodInsn(183, containerImplName, "<init>", containerCtorDesc, false);
        createContainer.visitInsn(176);
        createContainer.visitEnd();
        containerFactoryWriter.visitEnd();
        Class<?> ret = CcaAsmHelper.generateClass(containerFactoryWriter);
        return ret;
    }

    public static ComponentContainer createEmptyContainer() {
        try {
            Class<ComponentContainer> containerCls = CcaAsmHelper.spinComponentContainer(Runnable.class, Collections.emptyMap(), "Empty");
            return containerCls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new StaticComponentLoadingException("Failed to generate empty component container", e);
        }
    }

    protected ComponentContainer.Factory<T> buildContainerFactory() {
        this.ensureInitialized();
        return this.containerFactoryBuilder.build();
    }

    @Override
    protected void init() {
        StaticComponentPluginBase.processInitializers(this.getEntrypoints(), this::dispatchRegistration);
    }

    public static <I> void processInitializers(Collection<EntrypointContainer<I>> entrypoints, Consumer<I> action) {
        for (EntrypointContainer<I> entrypoint : entrypoints) {
            try {
                action.accept(entrypoint.getEntrypoint());
            }
            catch (Throwable e) {
                ModMetadata metadata = entrypoint.getProvider().getMetadata();
                throw new StaticComponentLoadingException(String.format("Exception while registering static component factories for %s (%s)", metadata.getName(), metadata.getId()), e);
            }
        }
    }

    public static <I extends ComponentRegistrationInitializer> Collection<EntrypointContainer<I>> getComponentEntrypoints(String key, Class<I> type) {
        List generic = FabricLoader.getInstance().getEntrypointContainers("cardinal-components", ComponentRegistrationInitializer.class);
        ArrayList<EntrypointContainer<I>> specific = new ArrayList<EntrypointContainer<I>>(FabricLoader.getInstance().getEntrypointContainers(key, type));
        for (EntrypointContainer container : generic) {
            if (!type.isInstance(container.getEntrypoint())) continue;
            EntrypointContainer c = container;
            specific.add(c);
        }
        return specific;
    }

    protected abstract Collection<EntrypointContainer<I>> getEntrypoints();

    protected abstract void dispatchRegistration(I var1);

    protected <C extends Component> void register(ComponentKey<C> key, ComponentFactory<T, ? extends C> factory) {
        this.containerFactoryBuilder.component(key, factory);
    }

    protected <C extends Component> void register(ComponentKey<? super C> key, Class<C> impl, ComponentFactory<T, ? extends C> factory) {
        this.containerFactoryBuilder.component(key, impl, factory);
    }
}

