/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl;

import com.llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicator;
import com.llamalad7.mixinextras.sugar.impl.SugarParameter;
import com.llamalad7.mixinextras.sugar.impl.TargetDecorations;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.ASMUtils;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

class ShareSugarApplicator
extends SugarApplicator {
    private final String id;
    private Type innerType;
    private int localRefIndex;
    private boolean needsSetup;

    ShareSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.id = this.mixin.getClassRef() + ':' + Annotations.getValue((AnnotationNode)this.sugar);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        this.innerType = LocalRefUtils.getTargetType(this.paramType, Type.getType(Object.class));
        if (this.innerType == this.paramType) {
            throw new SugarApplicationException("@Share parameter must be some variation of LocalRef.");
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node) {
        Map refIndices = TargetDecorations.getOrPut(target, "ShareSugar_LocalRefIndices", HashMap::new);
        boolean bl = this.needsSetup = !refIndices.containsKey(this.id);
        if (this.needsSetup) {
            this.localRefIndex = target.allocateLocal();
            refIndices.put(this.id, this.localRefIndex);
            target.addLocalVariable(this.localRefIndex, "sharedRef" + this.localRefIndex, this.paramType.getDescriptor());
        } else {
            this.localRefIndex = (Integer)refIndices.get(this.id);
        }
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node) {
        if (this.needsSetup) {
            InsnList init = new InsnList();
            LocalRefUtils.generateWrapping(init, this.innerType, () -> init.add((AbstractInsnNode)new InsnNode(ASMUtils.getDummyOpcodeForType(this.innerType))));
            init.add((AbstractInsnNode)new VarInsnNode(58, this.localRefIndex));
            target.insertBefore(target.insns.getFirst(), init);
        }
        target.insns.insertBefore(node.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, this.localRefIndex));
    }
}

