/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.antique_atlas.util.ForgeTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;

public class BiomeTileProviders
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final BiomeTileProviders INSTANCE = new BiomeTileProviders();
    public static final class_2960 ID = AntiqueAtlas.id("tile_provider/biome");
    private final Map<class_2960, TerrainTileProvider> tileProviders = new HashMap<class_2960, TerrainTileProvider>();
    private final Map<class_2960, class_2960> biomeFallbacks = new HashMap<class_2960, class_2960>();
    private boolean hasFallbacks = false;

    public static BiomeTileProviders getInstance() {
        return INSTANCE;
    }

    public BiomeTileProviders() {
        super(new Gson(), "atlas/biome");
    }

    public TerrainTileProvider getTileProvider(class_2960 providerId) {
        return this.tileProviders.getOrDefault(providerId, this.tileProviders.getOrDefault(this.biomeFallbacks.get(providerId), TerrainTileProvider.DEFAULT));
    }

    public void registerFallbacks(class_2378<class_1959> biomeRegistry) {
        for (class_1959 biome : biomeRegistry) {
            class_2960 biomeId = biomeRegistry.method_10221((Object)biome);
            if (this.tileProviders.containsKey(biomeId)) continue;
            class_2960 fallbackBiome = BiomeTileProviders.getFallbackBiome((class_6880<class_1959>)biomeRegistry.method_47983((Object)biome));
            if (fallbackBiome != null && this.tileProviders.containsKey(fallbackBiome)) {
                this.biomeFallbacks.put(biomeId, fallbackBiome);
                AntiqueAtlas.LOGGER.info("[Antique Atlas] Set fallback biome for {} to {}. You can set a more fitting texture using a resource pack!", (Object)biomeId, (Object)fallbackBiome);
                continue;
            }
            if (fallbackBiome != null) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Fallback biome for {} is {}, which has no defined tile provider.", (Object)biomeId, (Object)fallbackBiome);
                continue;
            }
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] No fallback could be found for {}. This shouldn't happen! This means the biome is not in ANY conventional or vanilla tag on the client!", (Object)biomeId);
            if (AntiqueAtlas.CONFIG.fallbackFailHandling != AntiqueAtlasConfig.FallbackHandling.CRASH) continue;
            throw new IllegalStateException("Antique Atlas fallback biome registration failed! Fix the missing biome or change fallbackFailHandling in antique_atlas.toml");
        }
        this.hasFallbacks = true;
    }

    public void clearFallbacks() {
        this.hasFallbacks = false;
        this.biomeFallbacks.clear();
    }

    public boolean hasFallbacks() {
        return this.hasFallbacks;
    }

    private static class_2960 getFallbackBiome(class_6880<class_1959> biome) {
        if (biome.method_40220(ConventionalBiomeTags.VOID) || biome.method_40220(ForgeTags.Biomes.IS_VOID)) {
            return class_1972.field_9473.method_29177();
        }
        if (biome.method_40220(class_6908.field_37394) || biome.method_40220(ConventionalBiomeTags.IN_THE_END) || biome.method_40220(ConventionalBiomeTags.END_ISLANDS)) {
            if (biome.method_40220(ConventionalBiomeTags.VEGETATION_DENSE) || biome.method_40220(ConventionalBiomeTags.VEGETATION_SPARSE) || biome.method_40220(ForgeTags.Biomes.IS_LUSH)) {
                return class_1972.field_9442.method_29177();
            }
            return class_1972.field_9465.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.NETHER_FORESTS)) {
            return class_1972.field_22075.method_29177();
        }
        if (biome.method_40220(class_6908.field_36518) || biome.method_40220(ConventionalBiomeTags.IN_NETHER)) {
            return class_1972.field_22076.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.SWAMP) || biome.method_40220(ForgeTags.Biomes.IS_SWAMP)) {
            return class_1972.field_9471.method_29177();
        }
        if (biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508) || biome.method_40220(ConventionalBiomeTags.DEEP_OCEAN) || biome.method_40220(ConventionalBiomeTags.OCEAN) || biome.method_40220(ConventionalBiomeTags.SHALLOW_OCEAN) || biome.method_40220(class_6908.field_36511) || biome.method_40220(ConventionalBiomeTags.RIVER) || biome.method_40220(ConventionalBiomeTags.AQUATIC) || biome.method_40220(ConventionalBiomeTags.AQUATIC_ICY) || biome.method_40220(ForgeTags.Biomes.IS_WATER)) {
            if (biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.AQUATIC_ICY)) {
                return class_1972.field_9463.method_29177();
            }
            return class_1972.field_9438.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.STONY_SHORES)) {
            return class_1972.field_9419.method_29177();
        }
        if (biome.method_40220(class_6908.field_36510) || biome.method_40220(ConventionalBiomeTags.BEACH)) {
            return class_1972.field_9434.method_29177();
        }
        if (biome.method_40220(class_6908.field_36516) || biome.method_40220(ConventionalBiomeTags.JUNGLE) || biome.method_40220(ConventionalBiomeTags.TREE_JUNGLE)) {
            return class_1972.field_9417.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.FLOWER_FORESTS) || biome.method_40220(ConventionalBiomeTags.FLORAL)) {
            return class_1972.field_9414.method_29177();
        }
        if (biome.method_40220(class_6908.field_37392) || biome.method_40220(ConventionalBiomeTags.SAVANNA) || biome.method_40220(ConventionalBiomeTags.TREE_SAVANNA)) {
            return class_1972.field_9449.method_29177();
        }
        if (biome.method_40220(class_6908.field_36513) || biome.method_40220(ConventionalBiomeTags.BADLANDS) || biome.method_40220(ConventionalBiomeTags.MESA)) {
            return class_1972.field_9415.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.TREE_CONIFEROUS) || biome.method_40220(ForgeTags.Biomes.IS_CONIFEROUS) || biome.method_40220(class_6908.field_36515) || biome.method_40220(ConventionalBiomeTags.TAIGA)) {
            if (biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.SNOWY)) {
                return class_1972.field_9454.method_29177();
            }
            return class_1972.field_9420.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.BIRCH_FOREST) || biome.method_40220(ConventionalBiomeTags.TREE_DECIDUOUS)) {
            return class_1972.field_9412.method_29177();
        }
        if (biome.method_40220(class_6908.field_36517) || biome.method_40220(ConventionalBiomeTags.FOREST)) {
            return class_1972.field_9409.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.PLAINS) || biome.method_40220(ConventionalBiomeTags.SNOWY_PLAINS) || biome.method_40220(ForgeTags.Biomes.IS_PLAINS) || biome.method_40220(ConventionalBiomeTags.SNOWY) || biome.method_40220(ForgeTags.Biomes.IS_SNOWY)) {
            if (biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.SNOWY)) {
                return class_1972.field_35117.method_29177();
            }
            return class_1972.field_9451.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.DESERT) || biome.method_40220(ConventionalBiomeTags.WASTELAND) || biome.method_40220(ConventionalBiomeTags.DEAD) || biome.method_40220(ForgeTags.Biomes.IS_SANDY) || biome.method_40220(ForgeTags.Biomes.IS_DESERT) || biome.method_40220(ForgeTags.Biomes.IS_DEAD) || biome.method_40220(ForgeTags.Biomes.IS_WASTELAND)) {
            return class_1972.field_9424.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.ICY)) {
            return class_1972.field_9435.method_29177();
        }
        if (biome.method_40220(ForgeTags.Biomes.IS_PLATEAU)) {
            return class_1972.field_34470.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.EXTREME_HILLS) || biome.method_40220(ConventionalBiomeTags.WINDSWEPT)) {
            return class_1972.field_35116.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.MOUNTAIN_PEAK) || biome.method_40220(ForgeTags.Biomes.IS_PEAK)) {
            return class_1972.field_34474.method_29177();
        }
        if (biome.method_40220(class_6908.field_36512) || biome.method_40220(ConventionalBiomeTags.MOUNTAIN) || biome.method_40220(ConventionalBiomeTags.MOUNTAIN_SLOPE) || biome.method_40220(ForgeTags.Biomes.IS_SLOPE) || biome.method_40220(ForgeTags.Biomes.IS_MOUNTAIN)) {
            return class_1972.field_34475.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.MUSHROOM) || biome.method_40220(ForgeTags.Biomes.IS_MUSHROOM)) {
            return class_1972.field_9462.method_29177();
        }
        if (biome.method_40220(class_6908.field_36514)) {
            return class_1972.field_35111.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CAVES) || biome.method_40220(ConventionalBiomeTags.UNDERGROUND) || biome.method_40220(ForgeTags.Biomes.IS_UNDERGROUND) || biome.method_40220(ForgeTags.Biomes.IS_CAVE)) {
            return class_1972.field_28107.method_29177();
        }
        if (biome.method_40220(ForgeTags.Biomes.IS_SPOOKY)) {
            return class_1972.field_9475.method_29177();
        }
        if (biome.method_40220(ForgeTags.Biomes.IS_MAGICAL)) {
            return class_1972.field_9462.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.VEGETATION_DENSE) || biome.method_40220(ForgeTags.Biomes.IS_DENSE)) {
            return class_1972.field_9409.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.VEGETATION_SPARSE) || biome.method_40220(ForgeTags.Biomes.IS_SPARSE)) {
            return class_1972.field_9451.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CLIMATE_HOT) || biome.method_40220(ForgeTags.Biomes.IS_HOT)) {
            return class_1972.field_9424.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CLIMATE_COLD) || biome.method_40220(ForgeTags.Biomes.IS_COLD)) {
            return class_1972.field_35117.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CLIMATE_TEMPERATE)) {
            return class_1972.field_9451.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CLIMATE_DRY) || biome.method_40220(ForgeTags.Biomes.IS_DRY)) {
            return class_1972.field_9415.method_29177();
        }
        if (biome.method_40220(ConventionalBiomeTags.CLIMATE_WET) || biome.method_40220(ForgeTags.Biomes.IS_WET)) {
            return class_1972.field_9471.method_29177();
        }
        return null;
    }

    public static TileTexture getTexture(Map<class_2960, TileTexture> textures, class_2960 id) {
        if (textures.containsKey(id)) {
            return textures.get(id);
        }
        throw new IllegalStateException("texture %s is not present!".formatted(id));
    }

    @Nullable
    public static List<TileTexture> resolveTextureJson(Map<class_2960, TileTexture> textures, JsonElement textureJson) {
        JsonObject textureObject;
        JsonPrimitive texturePrimitive;
        if (textureJson instanceof JsonPrimitive && (texturePrimitive = (JsonPrimitive)textureJson).isString()) {
            return List.of(BiomeTileProviders.getTexture(textures, new class_2960(texturePrimitive.getAsString())));
        }
        if (textureJson instanceof JsonArray) {
            JsonArray textureArray = (JsonArray)textureJson;
            return textureArray.asList().stream().map(je -> BiomeTileProviders.getTexture(textures, new class_2960(je.getAsString()))).toList();
        }
        if (textureJson instanceof JsonObject && (textureObject = (JsonObject)textureJson).keySet().stream().allMatch(k -> {
            JsonPrimitive jp;
            JsonElement patt0$temp = textureObject.get(k);
            return patt0$temp instanceof JsonPrimitive && (jp = (JsonPrimitive)patt0$temp).isNumber();
        })) {
            HashMultiset outList = HashMultiset.create();
            textureObject.entrySet().forEach(arg_0 -> BiomeTileProviders.lambda$resolveTextureJson$2((Multiset)outList, textures, arg_0));
            return outList.stream().toList();
        }
        return null;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Biome Tile Providers...");
        Map<class_2960, TileTexture> textures = TileTextures.getInstance().getTextures();
        HashSet<TileTexture> unusedTextures = new HashSet<TileTexture>(textures.values().stream().filter(t -> t.id().method_12832().startsWith("biome")).toList());
        HashMap<class_2960, class_2960> providerParents = new HashMap<class_2960, class_2960>();
        for (Map.Entry<class_2960, JsonElement> fileEntry : prepared.entrySet()) {
            class_2960 fileId = fileEntry.getKey();
            try {
                JsonObject fileJson = fileEntry.getValue().getAsJsonObject();
                if (fileJson.has("parent")) {
                    class_2960 parentId2 = new class_2960(fileJson.getAsJsonPrimitive("parent").getAsString());
                    providerParents.put(fileId, parentId2);
                    continue;
                }
                JsonElement textureJson = fileJson.get("textures");
                List<TileTexture> defaultTextures = BiomeTileProviders.resolveTextureJson(textures, textureJson);
                if (defaultTextures != null) {
                    defaultTextures.forEach(unusedTextures::remove);
                    this.tileProviders.put(fileId, new TerrainTileProvider(fileId, defaultTextures));
                    continue;
                }
                JsonObject textureObject = textureJson.getAsJsonObject();
                HashMap<TileElevation, List<TileTexture>> textureElevations = new HashMap<TileElevation, List<TileTexture>>();
                HashSet<TileElevation> skippedElevations = new HashSet<TileElevation>();
                List<TileTexture> elevationTextures = null;
                for (TileElevation elevation : TileElevation.values()) {
                    if (textureObject.has(elevation.getName())) {
                        elevationTextures = BiomeTileProviders.resolveTextureJson(textures, textureObject.get(elevation.getName()));
                        if (elevationTextures == null) {
                            throw new IllegalStateException("Malformed object %s in textures object!".formatted(elevation.getName()));
                        }
                        elevationTextures.forEach(unusedTextures::remove);
                        textureElevations.put(elevation, elevationTextures);
                        for (TileElevation skipped : skippedElevations) {
                            textureElevations.put(skipped, elevationTextures);
                        }
                        skippedElevations.clear();
                        continue;
                    }
                    skippedElevations.add(elevation);
                }
                if (textureElevations.isEmpty()) {
                    throw new IllegalStateException("No elevation keys were found in the textures object!");
                }
                for (TileElevation elevation : skippedElevations) {
                    textureElevations.put(elevation, elevationTextures);
                }
                this.tileProviders.put(fileId, new TerrainTileProvider(fileId, textureElevations));
            }
            catch (Exception e) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading biome tile provider {}!", (Object)fileId, (Object)e);
            }
        }
        providerParents.forEach((id, parentId) -> {
            if (this.tileProviders.containsKey(parentId)) {
                this.tileProviders.put((class_2960)id, this.tileProviders.get(parentId));
            } else {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Error reading biome tile provider {}!", id, (Object)new IllegalStateException("Parent id %s doesn't exist".formatted(parentId)));
            }
        });
        for (TileTexture texture : unusedTextures) {
            if (texture.displayId().startsWith("test") || texture.displayId().startsWith("base")) continue;
            AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} isn't referenced by any biome tile provider!", (Object)texture.displayId());
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(TileTextures.ID);
    }

    private static /* synthetic */ void lambda$resolveTextureJson$2(Multiset outList, Map textures, Map.Entry e) {
        outList.add((Object)BiomeTileProviders.getTexture(textures, new class_2960((String)e.getKey())), ((JsonElement)e.getValue()).getAsInt());
    }
}

