/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.tiles.TileRenderIterator;
import folk.sisby.antique_atlas.util.DrawBatcher;
import folk.sisby.antique_atlas.util.DrawUtil;
import folk.sisby.antique_atlas.util.MathUtil;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_768;
import net.minecraft.class_7833;
import org.joml.Vector2d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_759.class})
public class MixinHeldItemRenderer {
    @Inject(method={"renderFirstPersonMap"}, at={@At(value="HEAD")}, cancellable=true)
    void renderFirstPersonAtlas(class_4587 matrices, class_4597 vertexConsumers, int light, class_1799 stack, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        if (!AntiqueAtlas.isHandheldAtlas(stack)) {
            return;
        }
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        float scale = 0.24752294f;
        matrices.method_22905(scale, scale, 0.38f);
        matrices.method_22904(-1.2, -0.88, 0.0);
        matrices.method_22905(0.0078125f, 0.0078125f, 0.0078125f);
        int bookX = 0;
        int bookY = 0;
        int bookWidth = 310;
        int bookHeight = 218;
        int mapWidth = bookWidth - 34;
        int mapHeight = bookHeight - 22;
        int tileChunks = 1;
        try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, AtlasScreen.BOOK, bookWidth, bookHeight, light);){
            batcher.add(bookX, bookY, 0.01f, bookWidth, bookHeight, 0, 0, bookWidth, bookHeight, -1);
        }
        if (class_310.method_1551().field_1755 instanceof AtlasScreen) {
            matrices.method_22909();
            ci.cancel();
            return;
        }
        int mapOffsetX = -class_310.method_1551().field_1724.method_31477();
        int mapOffsetY = -class_310.method_1551().field_1724.method_31479();
        int mapStartChunkX = MathUtil.roundToBase((double)AtlasScreen.screenXToWorldX(bookX + 17, bookX, mapOffsetX, mapWidth, 1.0) / 16.0, (double)tileChunks) - 2 * tileChunks;
        int mapStartChunkZ = MathUtil.roundToBase((double)AtlasScreen.screenYToWorldZ(bookY + 11, bookY, mapOffsetY, mapHeight, 1.0) / 16.0, (double)tileChunks) - 2 * tileChunks;
        int mapEndChunkX = MathUtil.roundToBase((double)AtlasScreen.screenXToWorldX(bookX + 17 + mapWidth, bookX, mapOffsetX, mapWidth, 1.0) / 16.0, (double)tileChunks) + 2 * tileChunks;
        int mapEndChunkZ = MathUtil.roundToBase((double)AtlasScreen.screenYToWorldZ(bookY + 11 + mapHeight, bookY, mapOffsetY, mapHeight, 1.0) / 16.0, (double)tileChunks) + 2 * tileChunks;
        double mapStartScreenX = AtlasScreen.worldXToScreenX(mapStartChunkX << 4, bookX, mapOffsetX, mapWidth, 1.0);
        double mapStartScreenY = AtlasScreen.worldZToScreenY(mapStartChunkZ << 4, bookY, mapOffsetY, mapHeight, 1.0);
        WorldAtlasData worldAtlasData = WorldAtlasData.getOrCreate((class_1937)class_310.method_1551().field_1687);
        TileRenderIterator tiles = new TileRenderIterator(worldAtlasData);
        tiles.setScope(new Rect(mapStartChunkX, mapStartChunkZ, mapEndChunkX, mapEndChunkZ));
        tiles.setStep(tileChunks);
        AtlasScreen.renderTiles(matrices, vertexConsumers, bookX + 17, bookY + 11, 0, mapWidth, mapHeight, mapStartScreenX, mapStartScreenY, 1.0, 16, 1.0, light, tiles);
        class_768 mapArea = new class_768(bookX + 17, bookY + 11, mapWidth, mapHeight);
        worldAtlasData.getAllMarkers(tileChunks).forEach((landmark, texture) -> {
            double markerX = AtlasScreen.worldXToScreenX(landmark.pos().method_10263(), bookX, mapOffsetX, mapWidth, 1.0) - (double)bookX;
            double markerY = AtlasScreen.worldZToScreenY(landmark.pos().method_10260(), bookY, mapOffsetY, mapHeight, 1.0) - (double)bookY;
            class_1767 color = landmark.color();
            Vector2d markerPoint = new Vector2d(markerX, markerY);
            float alpha = (float)class_3532.method_15350((double)(MathUtil.innerDistanceToEdge(mapArea, markerPoint) / 32.0), (double)0.0, (double)1.0);
            texture.draw(matrices, vertexConsumers, markerX, markerY, -0.02f, 1.0f, tileChunks, color == null ? null : color.method_7787(), 1.0f, alpha, light);
        });
        Map friends = SurveyorClient.getFriends();
        PlayerSummary playerSummary = (PlayerSummary)friends.remove(SurveyorClient.getClientUuid());
        LinkedHashMap<UUID, PlayerSummary> orderedFriends = new LinkedHashMap<UUID, PlayerSummary>(friends);
        if (playerSummary != null) {
            orderedFriends.put(SurveyorClient.getClientUuid(), playerSummary);
        }
        orderedFriends.forEach((uuid, friend) -> {
            float tint = friend.online() ? 1.0f : 0.5f;
            float greenTint = friend == playerSummary ? 1.0f : 0.7f;
            int argb = class_5253.class_5254.method_27764((int)255, (int)((int)(tint * 255.0f)), (int)((int)(tint * greenTint * 255.0f)), (int)((int)(tint * 255.0f)));
            double playerOffsetX = AtlasScreen.worldXToScreenX(class_310.method_1551().field_1724.method_19538().method_10216(), bookX, mapOffsetX, mapWidth, 1.0) - (double)bookX;
            double playerOffsetY = AtlasScreen.worldZToScreenY(class_310.method_1551().field_1724.method_19538().method_10215(), bookY, mapOffsetY, mapHeight, 1.0) - (double)bookY;
            float playerRotation = (float)Math.round(class_310.method_1551().field_1724.method_5791() / 360.0f * 16.0f) / 16.0f * 360.0f;
            DrawUtil.drawCenteredWithRotation(matrices, vertexConsumers, AtlasScreen.PLAYER, playerOffsetX, playerOffsetY, -0.04f, 1.0f, 7, 8, playerRotation, light, argb);
        });
        try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, AtlasScreen.BOOK_FRAME, bookWidth, bookHeight, light);){
            batcher.add(bookX, bookY, -0.03f, bookWidth, bookHeight, 0, 0, bookWidth, bookHeight, -1);
        }
        matrices.method_22909();
        ci.cancel();
    }

    @ModifyExpressionValue(method={"renderFirstPersonItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal=0)})
    private boolean enableFirstPersonAtlasRendering(boolean original, class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 stack, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light) {
        return original || AntiqueAtlas.isHandheldAtlas(stack);
    }
}

