/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class Component
extends class_437 {
    private Component parent = null;
    private final List<Component> children = new CopyOnWriteArrayList<Component>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean isClipped = false;
    private int guiX = 0;
    private int guiY = 0;

    public Component() {
        super((class_2561)class_2561.method_43470((String)"component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (Component child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.updateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.updateSize();
    }

    protected Component addChild(Component child) {
        this.doAddChild(null, child, null);
        return child;
    }

    protected Component addChildBehind(Component behind, Component child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(Component inFrontOf, Component child, Component behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (class_310.method_1551() != null) {
            child.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        }
        this.updateSize();
    }

    protected Component removeChild(Component child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.updateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.updateSize();
    }

    public Component getParent() {
        return this.parent;
    }

    List<Component> getChildren() {
        return this.children;
    }

    boolean iterateInput(Predicate<Component> callMethod) {
        ListIterator<Component> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            Component child = iter.previous();
            if (!callMethod.test(child)) continue;
            return true;
        }
        return false;
    }

    boolean iterateMouseInput(Predicate<Component> callMethod) {
        return this.iterateInput(callMethod);
    }

    public boolean method_25402(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.method_25402(mx, my, mb))) {
            return super.method_25402(mx, my, mb);
        }
        return true;
    }

    public boolean method_25406(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.method_25406(mx, my, mb))) {
            return super.method_25406(mx, my, mb);
        }
        return true;
    }

    public boolean method_25403(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateMouseInput(c -> c.method_25403(mx, my, mb, mx2, my2))) {
            return super.method_25402(mx, my, mb);
        }
        return true;
    }

    public boolean method_25401(double mx, double my, double dy) {
        if (!this.iterateMouseInput(c -> c.method_25401(mx, my, dy))) {
            return super.method_25401(mx, my, dy);
        }
        return true;
    }

    public void method_16014(double mx, double my) {
        if (!this.iterateMouseInput(c -> {
            c.method_16014(mx, my);
            return false;
        })) {
            super.method_16014(mx, my);
        }
    }

    public boolean method_25404(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.method_25404(a, b, c))) {
            return super.method_25404(a, b, c);
        }
        return true;
    }

    public boolean method_25400(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.method_25400(aa, bb))) {
            return super.method_25400(aa, bb);
        }
        return true;
    }

    public boolean method_16803(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.method_16803(a, b, c))) {
            return super.method_16803(a, b, c);
        }
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTick) {
        super.method_25394(context, mouseX, mouseY, partialTick);
        for (Component child : this.children) {
            if (child.isClipped) continue;
            child.method_25394(context, mouseX, mouseY, partialTick);
        }
    }

    public void method_25419() {
        for (Component child : this.children) {
            child.method_25419();
        }
        super.method_25419();
    }

    public void method_25393() {
        for (Component child : this.children) {
            child.method_25393();
        }
        super.method_25393();
    }

    public void method_25426() {
        super.method_25426();
        for (Component child : this.children) {
            child.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        }
    }

    public int getWidth() {
        return this.contentWidth;
    }

    public int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    void updateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (Component child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        if (this.parent != null) {
            this.parent.updateSize();
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.getGuiX() && mouseX < (double)(this.getGuiX() + this.getWidth()) && mouseY >= (double)this.getGuiY() && mouseY < (double)(this.getGuiY() + this.getHeight());
    }

    public void closeChild() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            class_310.method_1551().method_1507(null);
        }
    }

    protected void onChildClosed(Component child) {
    }

    protected void drawCentered(class_332 context, class_2561 text, int y, int color, boolean dropShadow) {
        int length = this.field_22793.method_27525((class_5348)text);
        context.method_51439(this.field_22793, text, (this.field_22789 - length) / 2, y, color, dropShadow);
    }

    protected double getMouseX() {
        return class_310.method_1551().field_1729.method_1603() * (double)this.field_22789 / (double)class_310.method_1551().method_22683().method_4480();
    }

    protected double getMouseY() {
        return class_310.method_1551().field_1729.method_1604() * (double)this.field_22790 / (double)class_310.method_1551().method_22683().method_4507();
    }
}

