/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.Multimap;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.StructureTileProvider;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TerrainTiling;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.StructureTileProviders;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import it.unimi.dsi.fastutil.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7151;
import net.minecraft.class_746;

public class WorldAtlasData {
    public static final Map<class_5321<class_1937>, WorldAtlasData> WORLDS = new HashMap<class_5321<class_1937>, WorldAtlasData>();
    private final Map<class_1923, TileTexture> biomeTiles = new HashMap<class_1923, TileTexture>();
    private final Map<class_1923, TileTexture> structureTiles = new HashMap<class_1923, TileTexture>();
    private final Map<LandmarkType<?>, Map<class_2338, Pair<Landmark<?>, MarkerTexture>>> landmarkMarkers = new ConcurrentHashMap();
    private final Map<Landmark<?>, MarkerTexture> structureMarkers = new ConcurrentHashMap();
    private final Rect tileScope = new Rect(0, 0, 0, 0);
    private final Set<class_1923> terrainDequeHash = new HashSet<class_1923>();
    private final Deque<class_1923> terrainDeque = new ConcurrentLinkedDeque<class_1923>();
    boolean isFinished = false;
    private final Map<class_1923, String> debugBiomePredicates = new HashMap<class_1923, String>();
    private final Map<class_1923, String> debugStructurePredicates = new HashMap<class_1923, String>();
    private final Map<class_1923, TerrainTileProvider> debugBiomes = new HashMap<class_1923, TerrainTileProvider>();
    private final Map<class_1923, StructureTileProvider> debugStructures = new HashMap<class_1923, StructureTileProvider>();

    public static WorldAtlasData getOrCreate(class_1937 world) {
        return WORLDS.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new WorldAtlasData());
    }

    public static void onLoad(class_1937 world, WorldSummary summary, class_746 player, Map<class_1923, BitSet> terrain, Multimap<class_5321<class_3195>, class_1923> structures, Multimap<LandmarkType<?>, class_2338> landmarks) {
        WorldAtlasData data = WorldAtlasData.getOrCreate(world);
        data.onTerrainUpdated(world, summary.terrain(), WorldTerrainSummary.toKeys(terrain, (class_1923)player.method_31476()));
        data.onStructuresAdded(world, summary.structures(), structures);
        data.onLandmarksAdded(world, summary.landmarks(), landmarks);
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Beginning to load terrain for {} - {} chunks available.", (Object)world.method_27983().method_29177(), (Object)data.terrainDeque.size());
    }

    public void onTerrainUpdated(class_1937 world, WorldTerrainSummary ignored2, Collection<class_1923> chunks) {
        for (class_1923 pos : chunks) {
            if (this.biomeTiles.containsKey(pos) || this.terrainDequeHash.contains(pos)) continue;
            this.terrainDequeHash.add(pos);
            this.terrainDeque.add(pos);
        }
    }

    public void onStructuresAdded(class_1937 world, WorldStructureSummary ws, Multimap<class_5321<class_3195>, class_1923> summaries) {
        summaries.forEach((key, pos) -> StructureTileProviders.getInstance().resolve(this.structureTiles, this.debugStructures, this.debugStructurePredicates, this.structureMarkers, world, (class_5321<class_3195>)key, (class_1923)pos, ws.get(key, pos), (class_5321<class_7151<?>>)ws.getType(key), ws.getTags(key)));
    }

    public void tick(class_1937 world) {
        if (!BiomeTileProviders.getInstance().hasFallbacks()) {
            return;
        }
        for (int i = 0; i < AntiqueAtlas.CONFIG.chunkTickLimit; ++i) {
            Pair<TerrainTileProvider, TileElevation> tile;
            class_1923 pos = this.terrainDeque.pollFirst();
            this.terrainDequeHash.remove(pos);
            if (pos == null) break;
            Pair<TerrainTileProvider, TileElevation> pair = tile = world.method_27983() == class_1937.field_25180 ? TerrainTiling.terrainToTileNether(world, pos) : TerrainTiling.terrainToTile(world, pos);
            if (tile == null) continue;
            this.tileScope.extendTo(pos.field_9181, pos.field_9180);
            this.biomeTiles.put(pos, ((TerrainTileProvider)tile.left()).getTexture(pos, (TileElevation)((Object)tile.right())));
            this.debugBiomes.put(pos, (TerrainTileProvider)tile.left());
            this.debugBiomePredicates.put(pos, tile.right() == null ? null : ((TileElevation)((Object)tile.right())).getName());
        }
        if (!this.isFinished && this.terrainDeque.isEmpty()) {
            this.isFinished = true;
            AntiqueAtlas.LOGGER.info("[Antique Atlas] Finished loading terrain for {} - {} tiles.", (Object)world.method_27983().method_29177(), (Object)this.biomeTiles.size());
        }
    }

    public Rect getScope() {
        return this.tileScope;
    }

    public TileTexture getTile(int x, int z) {
        return this.getTile(new class_1923(x, z));
    }

    public TileTexture getTile(class_1923 pos) {
        if (!this.biomeTiles.containsKey(pos)) {
            return null;
        }
        return this.structureTiles.getOrDefault(pos, this.biomeTiles.get(pos));
    }

    public class_2960 getProvider(class_1923 pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructures.get(pos).id();
        }
        return this.debugBiomes.containsKey(pos) ? this.debugBiomes.get(pos).id() : null;
    }

    public String getTilePredicate(class_1923 pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructurePredicates.get(pos);
        }
        return this.debugBiomePredicates.get(pos);
    }

    private void addLandmarkMarker(Landmark<?> landmark, MarkerTexture texture) {
        this.landmarkMarkers.computeIfAbsent(landmark.type(), t -> new ConcurrentHashMap()).put(landmark.pos(), Pair.of(landmark, (Object)texture));
    }

    private void addLandmark(Landmark<?> baseLandmark) {
        if (baseLandmark.type() == PlayerDeathLandmark.TYPE) {
            PlayerDeathLandmark landmark = (PlayerDeathLandmark)baseLandmark;
            AntiqueAtlasConfig.GraveStyle style = AntiqueAtlas.CONFIG.graveStyle;
            if (landmark.name() == null && style == AntiqueAtlasConfig.GraveStyle.CAUSE) {
                style = AntiqueAtlasConfig.GraveStyle.DIED;
            }
            class_5250 timeText = class_2561.method_43470((String)String.valueOf(1L + landmark.created() / 24000L)).method_27692(class_124.field_1068);
            String key = "gui.antique_atlas.marker.death.%s".formatted(style.toString().toLowerCase());
            class_5250 text = switch (style) {
                default -> throw new IncompatibleClassChangeError();
                case AntiqueAtlasConfig.GraveStyle.CAUSE -> class_2561.method_43469((String)key, (Object[])new Object[]{landmark.name().method_27661().method_27692(class_124.field_1080).method_27692(class_124.field_1061), timeText}).method_27692(class_124.field_1080);
                case AntiqueAtlasConfig.GraveStyle.GRAVE, AntiqueAtlasConfig.GraveStyle.ITEMS, AntiqueAtlasConfig.GraveStyle.DIED -> class_2561.method_43469((String)key, (Object[])new Object[]{class_2561.method_43471((String)"gui.antique_atlas.marker.death.%s.verb".formatted(style.toString().toLowerCase())).method_27692(class_124.field_1061), timeText}).method_27692(class_124.field_1080);
                case AntiqueAtlasConfig.GraveStyle.EUPHEMISMS -> class_2561.method_43469((String)key, (Object[])new Object[]{class_2561.method_43471((String)"gui.antique_atlas.marker.death.%s.verb.%s".formatted(style.toString().toLowerCase(), new Random(landmark.seed()).nextInt(11))).method_27692(class_124.field_1061), timeText}).method_27692(class_124.field_1080);
            };
            this.addLandmarkMarker((Landmark<?>)new PlayerDeathLandmark(landmark.pos(), landmark.owner(), (class_2561)text, landmark.created(), landmark.seed()), MarkerTextures.getInstance().getLandmarkType(landmark.type(), style == AntiqueAtlasConfig.GraveStyle.ITEMS ? "items" : null));
        } else {
            this.addLandmarkMarker(baseLandmark, MarkerTextures.getInstance().getOrDefault(baseLandmark.texture(), MarkerTextures.getInstance().getLandmarkType(baseLandmark.type())));
        }
    }

    public void onLandmarksAdded(class_1937 ignored, WorldLandmarks worldLandmarks, Multimap<LandmarkType<?>, class_2338> landmarks) {
        landmarks.forEach((type, pos) -> this.addLandmark(worldLandmarks.get(type, pos)));
    }

    public void onLandmarksRemoved(class_1937 ignored, WorldLandmarks ignored2, Multimap<LandmarkType<?>, class_2338> landmarks) {
        landmarks.forEach((type, pos) -> {
            if (this.landmarkMarkers.containsKey(type)) {
                this.landmarkMarkers.get(type).remove(pos);
                if (this.landmarkMarkers.get(type).isEmpty()) {
                    this.landmarkMarkers.remove(type);
                }
            }
        });
    }

    public static boolean landmarkIsEditable(Landmark<?> landmark) {
        return landmark.owner() != null && SurveyorClient.getClientUuid().equals(landmark.owner());
    }

    public boolean deleteLandmark(class_1937 world, Landmark<?> landmark) {
        WorldLandmarks summary = WorldSummary.of((class_1937)world).landmarks();
        if (summary == null || !WorldAtlasData.landmarkIsEditable(landmark)) {
            return false;
        }
        summary.remove(world, landmark.type(), landmark.pos());
        return true;
    }

    public Map<Landmark<?>, MarkerTexture> getEditableLandmarks() {
        HashMap map = new HashMap();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> {
            if (WorldAtlasData.landmarkIsEditable((Landmark)pair.left())) {
                map.put((Landmark)pair.left(), (MarkerTexture)pair.right());
            }
        }));
        return map;
    }

    public Map<Landmark<?>, MarkerTexture> getAllMarkers(int tileChunks) {
        HashMap map = new HashMap();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> map.put((Landmark)pair.left(), (MarkerTexture)pair.right())));
        this.structureMarkers.forEach((landmark, texture) -> {
            if (tileChunks >= texture.nearClip() && tileChunks <= texture.farClip()) {
                map.put((Landmark<?>)landmark, (MarkerTexture)texture);
            }
        });
        return map;
    }

    public MarkerTexture getMarkerTexture(Landmark<?> landmark) {
        return this.landmarkMarkers.containsKey(landmark.type()) && this.landmarkMarkers.get(landmark.type()).containsKey(landmark.pos()) ? (MarkerTexture)this.landmarkMarkers.get(landmark.type()).get(landmark.pos()).right() : this.structureMarkers.get(landmark);
    }

    public void placeCustomMarker(class_1937 world, MarkerTexture selectedTexture, class_1767 color, class_5250 label, class_2338 blockPos) {
        WorldLandmarks summary = WorldSummary.of((class_1937)world).landmarks();
        if (summary == null) {
            return;
        }
        summary.put(world, (Landmark)new SimplePointLandmark(blockPos, SurveyorClient.getClientUuid(), color, (class_2561)label, null, selectedTexture.keyId()));
    }
}

