/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.Multimap;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.AntiqueAtlasKeybindings;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.StructureTileProviders;
import folk.sisby.antique_atlas.reloader.TileTextures;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3264;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntiqueAtlas
implements ClientModInitializer {
    public static final String ID = "antique_atlas";
    public static final String NAME = "Antique Atlas";
    public static final Logger LOGGER = LogManager.getLogger((String)"Antique Atlas");
    public static final AntiqueAtlasConfig CONFIG = (AntiqueAtlasConfig)AntiqueAtlasConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"antique-atlas", AntiqueAtlasConfig.class);
    public static ScreenState<AtlasScreen> lastState = new ScreenState();
    public static final class_1091 ATLAS_MODEL = new class_1091(AntiqueAtlas.id("atlas"), "inventory");
    public static final List<String> ATLAS_NAMES = List.of("Antique Atlas");

    public static class_2960 id(String path) {
        return path.contains(":") ? new class_2960(path) : new class_2960(ID, path);
    }

    public static class_1799 getHandheldAtlas() {
        class_1799 stack = class_1802.field_8529.method_7854().method_7972();
        stack.method_7977((class_2561)class_2561.method_43471((String)"item.antique_atlas.atlas").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        class_2499 lore = new class_2499();
        lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43471((String)"item.antique_atlas.atlas.lore").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))))));
        lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43469((String)"item.antique_atlas.atlas.hint", (Object[])new Object[]{class_2561.method_43471((String)"item.antique_atlas.atlas")}).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))))));
        stack.method_7941("display").method_10566("Lore", (class_2520)lore);
        return stack;
    }

    public static boolean isHandheldAtlas(class_1799 stack) {
        return stack.method_31574(class_1802.field_8529) && ATLAS_NAMES.stream().anyMatch(n -> stack.method_7964().getString().contains((CharSequence)n));
    }

    public static boolean hasHandheldAtlas(class_1657 player) {
        if (AntiqueAtlas.isHandheldAtlas(player.method_6079())) {
            return true;
        }
        for (class_1799 itemStack : player.method_31548().field_7547) {
            if (!AntiqueAtlas.isHandheldAtlas(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void onInitializeClient() {
        AntiqueAtlasKeybindings.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)TileTextures.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)StructureTileProviders.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)BiomeTileProviders.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)MarkerTextures.getInstance());
        SurveyorClientEvents.Register.worldLoad((class_2960)AntiqueAtlas.id("world_data"), WorldAtlasData::onLoad);
        SurveyorClientEvents.Register.terrainUpdated((class_2960)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onTerrainUpdated(w, s, k));
        SurveyorClientEvents.Register.structuresAdded((class_2960)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onStructuresAdded(w, s, (Multimap<class_5321<class_3195>, class_1923>)k));
        SurveyorClientEvents.Register.landmarksAdded((class_2960)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onLandmarksAdded(w, s, k));
        SurveyorClientEvents.Register.landmarksRemoved((class_2960)AntiqueAtlas.id("world_data"), (w, s, k) -> WorldAtlasData.getOrCreate(w).onLandmarksRemoved(w, s, k));
        ClientTickEvents.END_WORLD_TICK.register(w -> WorldAtlasData.getOrCreate((class_1937)w).tick((class_1937)w));
        CommonLifecycleEvents.TAGS_LOADED.register((manager, client) -> BiomeTileProviders.getInstance().registerFallbacks((class_2378<class_1959>)manager.method_30530(class_7924.field_41236)));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> BiomeTileProviders.getInstance().clearFallbacks());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WorldAtlasData.WORLDS.clear());
        class_5272.method_27879((class_1792)class_1802.field_8529, (class_2960)AntiqueAtlas.id("atlas"), (stack, world, entity, seed) -> AntiqueAtlas.isHandheldAtlas(stack) ? 1.0f : 0.0f);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(e -> e.addAfter((class_1935)class_1802.field_8895, new class_1799[]{AntiqueAtlas.getHandheldAtlas()}));
        WorldSummary.enableTerrain();
        WorldSummary.enableStructures();
        WorldSummary.enableLandmarks();
        FabricLoader.getInstance().getModContainer(ID).ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)AntiqueAtlas.asId("shader_patch"), (ModContainer)container, (String)"Shader Patch", (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
    }

    public static class_2960 asId(String path) {
        return class_2960.method_43902((String)ID, (String)path);
    }
}

