/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import glitchcore.event.TickEvent;
import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.event.player.PlayerInteractEvent;
import glitchcore.network.CustomPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.item.TANItems;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.DrinkInWorldPacket;
import toughasnails.network.UpdateThirstPacket;
import toughasnails.temperature.TemperatureData;

public class ThirstHandler {
    private static final int IN_WORLD_DRINK_COOLDOWN = 60;
    private static int inWorldDrinkTimer = 0;

    public static void onPlayerTick(Player player) {
        if (!ModConfig.thirst.enableThirst || player.m_9236_().m_5776_()) {
            return;
        }
        IThirst thirst = ThirstHelper.getThirst(player);
        Difficulty difficulty = player.m_9236_().m_46791_();
        double exhaustionThreshold = ModConfig.thirst.thirstExhaustionThreshold;
        if ((double)thirst.getExhaustion() > exhaustionThreshold) {
            thirst.addExhaustion((float)(-exhaustionThreshold));
            if (thirst.getHydration() > 0.0f) {
                thirst.setHydration(Math.max(thirst.getHydration() - 1.0f, 0.0f));
            } else if (difficulty != Difficulty.PEACEFUL) {
                thirst.setThirst(Math.max(thirst.getThirst() - 1, 0));
            }
        }
        if (thirst.getThirst() <= 0) {
            thirst.addTicks(1);
            if (thirst.getTickTimer() >= 80) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(player.m_269291_().m_269079_(TANDamageTypes.THIRST), 1.0f);
                }
                thirst.setTickTimer(0);
            }
        } else {
            thirst.setTickTimer(0);
        }
        if (difficulty == Difficulty.PEACEFUL && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && thirst.isThirsty() && player.f_19797_ % 10 == 0) {
            thirst.setThirst(thirst.getThirst() + 1);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
    }

    public static void syncThirst(ServerPlayer player) {
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateThirstPacket(thirst.getThirst(), thirst.getHydration()), player);
        thirst.setLastThirst(thirst.getThirst());
        thirst.setLastHydrationZero(thirst.getHydration() == 0.0f);
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.thirst.enableThirst || !(event.getEntity() instanceof Player) || event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack drink = event.getItem();
        IThirst thirst = ThirstHelper.getThirst(player);
        if (drink.m_204117_(ModTags.Items.DRINKS)) {
            int drink_thirst = ModTags.Items.getThirstRestored(drink);
            float drink_hydration = 0.0f;
            float drink_poison_chance = 0.0f;
            if (drink.m_204117_(ModTags.Items.TEN_HYDRATION_DRINKS)) {
                drink_hydration = 0.1f;
            }
            if (drink.m_204117_(ModTags.Items.TWENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.2f;
            }
            if (drink.m_204117_(ModTags.Items.THIRTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.3f;
            }
            if (drink.m_204117_(ModTags.Items.FOURTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.4f;
            }
            if (drink.m_204117_(ModTags.Items.FIFTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.5f;
            }
            if (drink.m_204117_(ModTags.Items.SIXTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.6f;
            }
            if (drink.m_204117_(ModTags.Items.SEVENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.7f;
            }
            if (drink.m_204117_(ModTags.Items.EIGHTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.8f;
            }
            if (drink.m_204117_(ModTags.Items.NINETY_HYDRATION_DRINKS)) {
                drink_hydration = 0.9f;
            }
            if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_HYDRATION_DRINKS)) {
                drink_hydration = 1.0f;
            }
            if (drink.m_204117_(ModTags.Items.TWENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.25f;
            }
            if (drink.m_204117_(ModTags.Items.FIFTY_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.5f;
            }
            if (drink.m_204117_(ModTags.Items.SEVENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.75f;
            }
            if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 1.0f;
            }
            thirst.drink(drink_thirst, drink_hydration);
            if (player.m_9236_().f_46441_.m_188501_() < drink_poison_chance) {
                player.m_7292_(new MobEffectInstance(TANEffects.THIRST, 600));
            }
        }
    }

    public static void onPlayerUseItem(PlayerInteractEvent.UseItem event) {
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item != Items.f_42590_) {
            return;
        }
        BlockHitResult rayTraceResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rayTraceResult.m_82425_();
        if (!level.m_7966_(player, pos) || !level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return;
        }
        level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        Holder biome = level.m_204166_(pos);
        ItemStack filledStack = biome.m_203656_(ModTags.Biomes.DIRTY_WATER_BIOMES) ? new ItemStack((ItemLike)TANItems.DIRTY_WATER_BOTTLE) : (biome.m_203656_(ModTags.Biomes.PURIFIED_WATER_BIOMES) ? new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE) : PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        ItemStack replacementStack = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)filledStack);
        event.setCancelResult(InteractionResultHolder.m_19092_((Object)replacementStack, (boolean)level.m_5776_()));
        event.setCancelled(true);
    }

    public static void onUseBlock(PlayerInteractEvent.UseBlock event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onUseEmpty(PlayerInteractEvent.UseEmpty event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        if (inWorldDrinkTimer > 0) {
            --inWorldDrinkTimer;
        }
    }

    private static boolean canHandDrink() {
        return ModConfig.thirst.enableThirst && ModConfig.thirst.enableHandDrinking;
    }

    private static boolean canHandDrinkInWorld(Player player, InteractionHand hand) {
        return InteractionHand.MAIN_HAND == hand && player.m_21205_().m_41619_() && player.m_6047_() && ThirstHelper.getThirst(player).getThirst() < 20 && player.m_9236_().m_5776_() && inWorldDrinkTimer <= 0;
    }

    private static void tryDrinkWaterInWorld(Player player) {
        Level world = player.m_9236_();
        BlockHitResult rayTraceResult = Item.m_41435_((Level)player.m_9236_(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.m_82425_();
            if (ThirstHelper.canDrink(player, false) && world.m_7966_(player, pos) && world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                inWorldDrinkTimer = 60;
                ModPackets.HANDLER.sendToServer((CustomPacket)new DrinkInWorldPacket(pos));
                player.m_5496_(SoundEvents.f_11911_, 0.5f, 1.0f);
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }
}

