/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.collect.Lists;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.mixin.CraftingInventoryAccessor;
import io.github.apace100.apoli.mixin.CraftingScreenHandlerAccessor;
import io.github.apace100.apoli.mixin.PlayerScreenHandlerAccessor;
import io.github.apace100.apoli.power.RecipePower;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class PowerRestrictedCraftingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(PowerRestrictedCraftingRecipe::new);

    public PowerRestrictedCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        if (inventory instanceof TransientCraftingContainer) {
            TransientCraftingContainer craftingInventory = (TransientCraftingContainer)inventory;
            return this.getRecipes(craftingInventory).stream().anyMatch(r -> r.m_5818_((Container)craftingInventory, world));
        }
        return false;
    }

    public ItemStack craft(CraftingContainer inventory, RegistryAccess registryManager) {
        Optional<Recipe> optional;
        TransientCraftingContainer craftingInventory;
        Player player;
        if (inventory instanceof TransientCraftingContainer && (player = this.getPlayerFromInventory(craftingInventory = (TransientCraftingContainer)inventory)) != null && (optional = this.getRecipes(craftingInventory).stream().filter(r -> r.m_5818_((Container)craftingInventory, player.m_9236_())).findFirst()).isPresent()) {
            Recipe recipe = optional.get();
            return recipe.m_5874_((Container)craftingInventory, registryManager);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    private Player getPlayerFromInventory(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        return this.getPlayerFromHandler(handler);
    }

    private List<Recipe<TransientCraftingContainer>> getRecipes(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = ((CraftingInventoryAccessor)inv).getHandler();
        Player player = this.getPlayerFromHandler(handler);
        if (player != null) {
            return PowerHolderComponent.getPowers((Entity)player, RecipePower.class).stream().map(RecipePower::getRecipe).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private Player getPlayerFromHandler(AbstractContainerMenu screenHandler) {
        if (screenHandler instanceof CraftingMenu) {
            return ((CraftingScreenHandlerAccessor)screenHandler).getPlayer();
        }
        if (screenHandler instanceof InventoryMenu) {
            return ((PlayerScreenHandlerAccessor)screenHandler).getOwner();
        }
        return null;
    }
}

