/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class PowerLootCondition
implements LootItemCondition {
    public static final LootItemConditionType TYPE = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final ResourceLocation powerId;
    private final ResourceLocation powerSourceId;

    private PowerLootCondition(ResourceLocation powerId) {
        this.powerId = powerId;
        this.powerSourceId = null;
    }

    private PowerLootCondition(ResourceLocation powerId, ResourceLocation powerSourceId) {
        this.powerId = powerId;
        this.powerSourceId = powerSourceId;
    }

    public LootItemConditionType m_7940_() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        Optional optionalPowerHolderComponent = PowerHolderComponent.KEY.maybeGet(lootContext.m_78953_(LootContextParams.f_81455_));
        if (optionalPowerHolderComponent.isPresent()) {
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)optionalPowerHolderComponent.get();
            PowerType powerType = PowerTypeRegistry.get(this.powerId);
            if (this.powerSourceId != null) {
                return powerHolderComponent.hasPower(powerType, this.powerSourceId);
            }
            return powerHolderComponent.hasPower(powerType);
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PowerLootCondition> {
        public void toJson(JsonObject jsonObject, PowerLootCondition powerLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("power", powerLootCondition.powerId.toString());
            if (powerLootCondition.powerSourceId != null) {
                jsonObject.addProperty("source", powerLootCondition.powerSourceId.toString());
            }
        }

        public PowerLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ResourceLocation power = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"power"));
            if (jsonObject.has("source")) {
                ResourceLocation source = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"source"));
                return new PowerLootCondition(power, source);
            }
            return new PowerLootCondition(power);
        }
    }
}

