/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class HudRender {
    public static final HudRender DONT_RENDER = new HudRender(false, 0, Apoli.identifier("textures/gui/resource_bar.png"), null, false);
    private final boolean shouldRender;
    private final int barIndex;
    private final ResourceLocation spriteLocation;
    private final ConditionFactory.Instance playerCondition;
    private final boolean inverted;

    public HudRender(boolean shouldRender, int barIndex, ResourceLocation spriteLocation, ConditionFactory.Instance condition, boolean inverted) {
        this.shouldRender = shouldRender;
        this.barIndex = barIndex;
        this.spriteLocation = spriteLocation;
        this.playerCondition = condition;
        this.inverted = inverted;
    }

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation;
    }

    public int getBarIndex() {
        return this.barIndex;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public boolean shouldRender(Player player) {
        return this.shouldRender && (this.playerCondition == null || this.playerCondition.test(player));
    }

    public ConditionFactory.Instance getCondition() {
        return this.playerCondition;
    }
}

