/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import java.util.Comparator;
import java.util.List;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class AttributeUtil {
    public static void sortModifiers(List<AttributeModifier> modifiers) {
        modifiers.sort(Comparator.comparing(e -> e.m_22217_().m_22235_()));
    }

    public static double sortAndApplyModifiers(List<AttributeModifier> modifiers, double baseValue) {
        AttributeUtil.sortModifiers(modifiers);
        return AttributeUtil.applyModifiers(modifiers, baseValue);
    }

    public static double applyModifiers(List<AttributeModifier> modifiers, double baseValue) {
        double currentValue = baseValue;
        if (modifiers != null) {
            for (AttributeModifier modifier : modifiers) {
                switch (modifier.m_22217_()) {
                    case ADDITION: {
                        currentValue += modifier.m_22218_();
                        break;
                    }
                    case MULTIPLY_BASE: {
                        currentValue += baseValue * modifier.m_22218_();
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        currentValue *= 1.0 + modifier.m_22218_();
                    }
                }
            }
        }
        return currentValue;
    }
}

