/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.world.entity.Entity;

public class ResourceCondition {
    public static boolean condition(SerializableData.Instance data, Entity entity) {
        PowerType powerType = (PowerType)data.get("resource");
        Comparison comparison = (Comparison)((Object)data.get("comparison"));
        int compareTo = (Integer)data.get("compare_to");
        return PowerHolderComponent.KEY.maybeGet((Object)entity).map(component -> ResourceCondition.comparePowerValue(component, powerType, comparison, compareTo)).orElse(false);
    }

    private static boolean comparePowerValue(PowerHolderComponent component, PowerType<?> powerType, Comparison comparison, int compareTo) {
        Integer powerValue = null;
        Object power = component.getPower(powerType);
        if (power instanceof VariableIntPower) {
            VariableIntPower vip = (VariableIntPower)power;
            powerValue = vip.getValue();
        } else if (power instanceof CooldownPower) {
            CooldownPower cp = (CooldownPower)power;
            powerValue = cp.getRemainingTicks();
        }
        return powerValue != null && comparison.compare(powerValue.intValue(), compareTo);
    }

    public static ConditionFactory<Entity> getFactory() {
        return new ConditionFactory<Entity>(Apoli.identifier("resource"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), ResourceCondition::condition);
    }
}

