/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.Entity;

public class InventoryCondition {
    public static boolean condition(SerializableData.Instance data, Entity entity) {
        Set inventoryTypes = (Set)data.get("inventory_types");
        Comparison comparison = (Comparison)((Object)data.get("comparison"));
        InventoryUtil.ProcessMode processMode = (InventoryUtil.ProcessMode)((Object)data.get("process_mode"));
        boolean result = false;
        int compareTo = (Integer)data.get("compare_to");
        int matches = 0;
        if (inventoryTypes.contains((Object)InventoryUtil.InventoryType.INVENTORY)) {
            result = comparison.compare(matches += InventoryUtil.checkInventory(data, entity, null, processMode.getProcessor()), compareTo);
        }
        if (inventoryTypes.contains((Object)InventoryUtil.InventoryType.POWER)) {
            PowerType targetPowerType = (PowerType)data.get("power");
            if (targetPowerType == null) {
                return result;
            }
            Optional opt$component = PowerHolderComponent.KEY.maybeGet((Object)entity);
            if (opt$component.isEmpty()) {
                return result;
            }
            Object targetPower = ((PowerHolderComponent)opt$component.get()).getPower(targetPowerType);
            if (!(targetPower instanceof InventoryPower)) {
                return result;
            }
            InventoryPower inventoryPower = (InventoryPower)targetPower;
            result = comparison.compare(matches += InventoryUtil.checkInventory(data, entity, inventoryPower, processMode.getProcessor()), compareTo);
        }
        return result;
    }

    public static ConditionFactory<Entity> getFactory() {
        return new ConditionFactory<Entity>(Apoli.identifier("inventory"), new SerializableData().add("inventory_types", ApoliDataTypes.INVENTORY_TYPE_SET, EnumSet.of(InventoryUtil.InventoryType.INVENTORY)).add("process_mode", ApoliDataTypes.PROCESS_MODE, (Object)InventoryUtil.ProcessMode.ITEMS).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("slots", ApoliDataTypes.ITEM_SLOTS, null).add("slot", ApoliDataTypes.ITEM_SLOT, null).add("power", ApoliDataTypes.POWER_TYPE, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN).add("compare_to", SerializableDataTypes.INT, (Object)0), InventoryCondition::condition);
    }
}

