/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;

public class BlockCollisionCondition {
    public static boolean condition(SerializableData.Instance data, Entity entity) {
        AABB entityBoundingBox = entity.m_20191_();
        AABB offsetEntityBoundingBox = entityBoundingBox.m_82386_((double)data.getFloat("offset_x") * entityBoundingBox.m_82362_(), (double)data.getFloat("offset_y") * entityBoundingBox.m_82376_(), (double)data.getFloat("offset_z") * entityBoundingBox.m_82385_());
        if (data.isPresent("block_condition")) {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            BlockPos minBlockPos = BlockPos.m_274561_((double)(offsetEntityBoundingBox.f_82288_ + 0.001), (double)(offsetEntityBoundingBox.f_82289_ + 0.001), (double)(offsetEntityBoundingBox.f_82290_ + 0.001));
            BlockPos maxBlockPos = BlockPos.m_274561_((double)(offsetEntityBoundingBox.f_82291_ - 0.001), (double)(offsetEntityBoundingBox.f_82292_ - 0.001), (double)(offsetEntityBoundingBox.f_82293_ - 0.001));
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int matchingBlocks = 0;
            for (int x = minBlockPos.m_123341_(); x <= maxBlockPos.m_123341_(); ++x) {
                for (int y = minBlockPos.m_123342_(); y <= maxBlockPos.m_123342_(); ++y) {
                    for (int z = minBlockPos.m_123343_(); z <= maxBlockPos.m_123343_(); ++z) {
                        mutableBlockPos.m_122178_(x, y, z);
                        if (!blockCondition.test(new BlockInWorld((LevelReader)entity.m_9236_(), (BlockPos)mutableBlockPos, true))) continue;
                        ++matchingBlocks;
                    }
                }
            }
            return matchingBlocks > 0;
        }
        return entity.m_9236_().m_186434_(entity, offsetEntityBoundingBox).iterator().hasNext();
    }

    public static ConditionFactory<Entity> getFactory() {
        return new ConditionFactory<Entity>(Apoli.identifier("block_collision"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("offset_x", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("offset_y", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("offset_z", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)), BlockCollisionCondition::condition);
    }
}

