/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.item.EnchantmentCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemConditions {
    public static void register() {
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, stack) -> data.getBoolean("value")));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.ITEM_CONDITIONS), (data, stack) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(stack))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("food"), new SerializableData(), (data, stack) -> stack.m_41614_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("ingredient"), new SerializableData().add("ingredient", SerializableDataTypes.INGREDIENT), (data, stack) -> ((Ingredient)data.get("ingredient")).test(stack)));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("armor_value"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> {
            int armor = 0;
            if (stack.m_41720_() instanceof ArmorItem) {
                ArmorItem item = (ArmorItem)stack.m_41720_();
                armor = item.m_40404_();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(armor, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("harvest_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> {
            int harvestLevel = 0;
            if (stack.m_41720_() instanceof TieredItem) {
                TieredItem item = (TieredItem)stack.m_41720_();
                harvestLevel = item.m_43314_().m_6604_();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(harvestLevel, data.getInt("compare_to"));
        }));
        ItemConditions.register(EnchantmentCondition.getFactory());
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("meat"), new SerializableData(), (data, stack) -> stack.m_41614_() && stack.m_41720_().m_41473_().m_38746_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, stack) -> NbtUtils.m_129235_((Tag)((Tag)data.get("nbt")), (Tag)stack.m_41783_(), (boolean)true)));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("fireproof"), new SerializableData(), (data, stack) -> stack.m_41720_().m_41475_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("enchantable"), new SerializableData(), (data, stack) -> !stack.m_41792_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("power_count"), new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("compare_to", SerializableDataTypes.INT).add("comparison", ApoliDataTypes.COMPARISON), (data, stack) -> {
            int totalCount = 0;
            if (data.isPresent("slot")) {
                totalCount = StackPowerUtil.getPowers(stack, (EquipmentSlot)data.get("slot")).size();
            } else {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    totalCount += StackPowerUtil.getPowers(stack, slot).size();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(totalCount, data.getInt("compare_to"));
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("has_power"), new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("power", SerializableDataTypes.IDENTIFIER), (data, stack) -> {
            ResourceLocation power = data.getId("power");
            if (data.isPresent("slot")) {
                return StackPowerUtil.getPowers(stack, (EquipmentSlot)data.get("slot")).stream().anyMatch(p -> p.powerId.equals((Object)power));
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!StackPowerUtil.getPowers(stack, slot).stream().anyMatch(p -> p.powerId.equals((Object)power))) continue;
                return true;
            }
            return false;
        }));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("empty"), new SerializableData(), (data, stack) -> stack.m_41619_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("amount"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(stack.m_41613_(), data.getInt("compare_to"))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("is_damageable"), new SerializableData(), (data, stack) -> stack.m_41763_()));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("durability"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(stack.m_41776_() - stack.m_41773_(), data.getInt("compare_to"))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("relative_durability"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, stack) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare((float)(stack.m_41776_() - stack.m_41773_()) / (float)stack.m_41776_(), data.getFloat("compare_to"))));
        ItemConditions.register(new ConditionFactory<ItemStack>(Apoli.identifier("is_equippable"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT), (data, stack) -> Mob.m_147233_((ItemStack)stack) == data.get("equipment_slot")));
    }

    private static void register(ConditionFactory<ItemStack> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.ITEM_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

