/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.apace100.apoli.power.ClimbingPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.entity.BlockCollisionCondition;
import io.github.apace100.apoli.power.factory.condition.entity.BrightnessCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ElytraFlightPossibleCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ExposedToSunCondition;
import io.github.apace100.apoli.power.factory.condition.entity.InventoryCondition;
import io.github.apace100.apoli.power.factory.condition.entity.PowerCondition;
import io.github.apace100.apoli.power.factory.condition.entity.RaycastCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ResourceCondition;
import io.github.apace100.apoli.power.factory.condition.entity.ScoreboardCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.ladysnake.pal.PlayerAbility;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.AABB;

public class EntityConditions {
    public static void register() {
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, entity) -> data.getBoolean("value")));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(entity))));
        EntityConditions.register(BlockCollisionCondition.getFactory());
        EntityConditions.register(BrightnessCondition.getFactory());
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("daytime"), new SerializableData(), (data, entity) -> entity.m_9236_().m_46468_() % 24000L < 13000L));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("time_of_day"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.m_9236_().m_46468_() % 24000L, data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("fall_flying"), new SerializableData(), (data, entity) -> entity instanceof LivingEntity && ((LivingEntity)entity).m_21255_()));
        EntityConditions.register(ExposedToSunCondition.getFactory());
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("in_rain"), new SerializableData(), (data, entity) -> ((EntityAccessor)entity).callIsBeingRainedOn()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("invisible"), new SerializableData(), (data, entity) -> entity.m_20145_()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("on_fire"), new SerializableData(), (data, entity) -> entity.m_6060_()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("exposed_to_sky"), new SerializableData(), (data, entity) -> {
            BlockPos blockPos = entity.m_20202_() instanceof Boat ? BlockPos.m_274561_((double)entity.m_20185_(), (double)Math.round(entity.m_20186_()), (double)entity.m_20189_()).m_7494_() : BlockPos.m_274561_((double)entity.m_20185_(), (double)Math.round(entity.m_20186_()), (double)entity.m_20189_());
            return entity.m_9236_().m_45527_(blockPos);
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("sneaking"), new SerializableData(), (data, entity) -> entity.m_6144_()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("sprinting"), new SerializableData(), (data, entity) -> entity.m_20142_()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("power_active"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> ((PowerTypeReference)data.get("power")).isActive((Entity)entity)));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("status_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT).add("min_amplifier", SerializableDataTypes.INT, (Object)0).add("max_amplifier", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE).add("min_duration", SerializableDataTypes.INT, (Object)0).add("max_duration", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE), (data, entity) -> {
            LivingEntity living;
            MobEffect effect = (MobEffect)data.get("effect");
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(effect)) {
                MobEffectInstance instance = living.m_21124_(effect);
                return instance.m_19557_() <= data.getInt("max_duration") && instance.m_19557_() >= data.getInt("min_duration") && instance.m_19564_() <= data.getInt("max_amplifier") && instance.m_19564_() >= data.getInt("min_amplifier");
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("submerged_in"), new SerializableData().add("fluid", SerializableDataTypes.FLUID_TAG), (data, entity) -> ((SubmergableEntity)entity).isSubmergedInLoosely((TagKey<Fluid>)((TagKey)data.get("fluid")))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("fluid_height"), new SerializableData().add("fluid", SerializableDataTypes.FLUID_TAG).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((SubmergableEntity)entity).getFluidHeightLoosely((TagKey<Fluid>)((TagKey)data.get("fluid"))), data.getDouble("compare_to"))));
        EntityConditions.register(PowerCondition.getFactory());
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("food_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof Player) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Player)entity).m_36324_().m_38702_(), data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("saturation_level"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof Player) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Player)entity).m_36324_().m_38722_(), data.getFloat("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("on_block"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null), (data, entity) -> entity.m_20096_() && (!data.isPresent("block_condition") || ((ConditionFactory.Instance)data.get("block_condition")).test(new BlockInWorld((LevelReader)entity.m_9236_(), BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20191_().f_82289_ - 0.5000001), (double)entity.m_20189_()), true)))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("equipped_item"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT).add("item_condition", ApoliDataTypes.ITEM_CONDITION), (data, entity) -> entity instanceof LivingEntity && ((ConditionFactory.Instance)data.get("item_condition")).test(((LivingEntity)entity).m_6844_((EquipmentSlot)data.get("equipment_slot")))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("attribute"), new SerializableData().add("attribute", SerializableDataTypes.ATTRIBUTE).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), (data, entity) -> {
            LivingEntity living;
            AttributeInstance attributeInstance;
            double attrValue = 0.0;
            if (entity instanceof LivingEntity && (attributeInstance = (living = (LivingEntity)entity).m_21051_((Attribute)data.get("attribute"))) != null) {
                attrValue = attributeInstance.m_22135_();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(attrValue, data.getDouble("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("swimming"), new SerializableData(), (data, entity) -> entity.m_6069_()));
        EntityConditions.register(ResourceCondition.getFactory());
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("air"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.m_20146_(), data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("in_block"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("block_condition")).test(new BlockInWorld((LevelReader)entity.m_9236_(), entity.m_20183_(), true))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("block_in_radius"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION).add("radius", SerializableDataTypes.INT).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("compare_to", SerializableDataTypes.INT, (Object)1).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            for (BlockPos pos : Shape.getPositions(entity.m_20183_(), (Shape)((Object)((Object)data.get("shape"))), data.getInt("radius"))) {
                if (!blockCondition.test(new BlockInWorld((LevelReader)entity.m_9236_(), pos, true)) || ++count != stopAt) continue;
                break;
            }
            return comparison.compare(count, compareTo);
        }));
        DistanceFromCoordinatesConditionRegistry.registerEntityCondition(EntityConditions::register);
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("dimension"), new SerializableData().add("dimension", SerializableDataTypes.IDENTIFIER), (data, entity) -> entity.m_9236_().m_46472_() == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)data.getId("dimension"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("xp_levels"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof Player) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Player)entity).f_36078_, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("xp_points"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof Player) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Player)entity).f_36079_, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("health"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity instanceof LivingEntity ? (double)((LivingEntity)entity).m_21223_() : 0.0, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("relative_health"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> {
            float health = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                health = living.m_21223_() / living.m_21233_();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(health, data.getFloat("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("biome"), new SerializableData().add("biome", SerializableDataTypes.IDENTIFIER, null).add("biomes", SerializableDataTypes.IDENTIFIERS, null).add("condition", ApoliDataTypes.BIOME_CONDITION, null), (data, entity) -> {
            Holder biomeEntry = entity.m_9236_().m_204166_(entity.m_20183_());
            Biome biome = (Biome)biomeEntry.m_203334_();
            ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("condition");
            if (data.isPresent("biome") || data.isPresent("biomes")) {
                ResourceLocation biomeId = entity.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
                if (data.isPresent("biome") && biomeId.equals((Object)data.getId("biome"))) {
                    return condition == null || condition.test(biomeEntry);
                }
                if (data.isPresent("biomes") && ((List)data.get("biomes")).contains(biomeId)) {
                    return condition == null || condition.test(biomeEntry);
                }
                return false;
            }
            return condition == null || condition.test(biomeEntry);
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("entity_type"), new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE), (data, entity) -> entity.m_6095_() == data.get("entity_type")));
        EntityConditions.register(ScoreboardCondition.getFactory());
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("command"), new SerializableData().add("command", SerializableDataTypes.STRING).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, entity) -> {
            MinecraftServer server = entity.m_9236_().m_7654_();
            if (server != null) {
                boolean validOutput = !(entity instanceof ServerPlayer) || ((ServerPlayer)entity).f_8906_ != null;
                CommandSourceStack source = new CommandSourceStack((CommandSource)(Apoli.config.executeCommand.showOutput && validOutput ? entity : CommandSource.f_80164_), entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, Apoli.config.executeCommand.permissionLevel, entity.m_7755_().getString(), entity.m_5446_(), server, entity);
                int output = server.m_129892_().m_230957_(source, data.getString("command"));
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(output, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("predicate"), new SerializableData().add("predicate", SerializableDataTypes.IDENTIFIER), (data, entity) -> {
            LootItemCondition lootCondition;
            MinecraftServer server = entity.m_9236_().m_7654_();
            if (server != null && (lootCondition = (LootItemCondition)server.m_278653_().m_278789_(LootDataType.f_278407_, (ResourceLocation)data.get("predicate"))) != null) {
                LootParams lootContextParameterSet = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287289_(LootContextParams.f_81455_, entity).m_287235_(LootContextParamSets.f_81412_);
                LootContext lootContext = new LootContext.Builder(lootContextParameterSet).m_287259_(null);
                return lootCondition.test((Object)lootContext);
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("fall_distance"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.f_19789_, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("collided_horizontally"), new SerializableData(), (data, entity) -> entity.f_19862_));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("in_block_anywhere"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case NOT_EQUAL: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            AABB box = entity.m_20191_();
            BlockPos blockPos = BlockPos.m_274561_((double)(box.f_82288_ + 0.001), (double)(box.f_82289_ + 0.001), (double)(box.f_82290_ + 0.001));
            BlockPos blockPos2 = BlockPos.m_274561_((double)(box.f_82291_ - 0.001), (double)(box.f_82292_ - 0.001), (double)(box.f_82293_ - 0.001));
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = blockPos.m_123341_(); i <= blockPos2.m_123341_() && count < stopAt; ++i) {
                for (int j = blockPos.m_123342_(); j <= blockPos2.m_123342_() && count < stopAt; ++j) {
                    for (int k = blockPos.m_123343_(); k <= blockPos2.m_123343_() && count < stopAt; ++k) {
                        mutable.m_122178_(i, j, k);
                        if (!blockCondition.test(new BlockInWorld((LevelReader)entity.m_9236_(), (BlockPos)mutable, true))) continue;
                        ++count;
                    }
                }
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("entity_group"), new SerializableData().add("group", SerializableDataTypes.ENTITY_GROUP), (data, entity) -> entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == data.get("group")));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.ENTITY_TAG), (data, entity) -> entity.m_6095_().m_204041_().m_203656_((TagKey)data.get("tag"))));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("climbing"), new SerializableData(), (data, entity) -> {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6147_()) {
                return true;
            }
            if (PowerHolderComponent.hasPower(entity, ClimbingPower.class)) {
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("tamed"), new SerializableData(), (data, entity) -> {
            if (entity instanceof TamableAnimal) {
                return ((TamableAnimal)entity).m_21824_();
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("using_item"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null), (data, entity) -> {
            LivingEntity living;
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6117_()) {
                ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("item_condition");
                if (condition != null) {
                    InteractionHand activeHand = living.m_7655_();
                    ItemStack handStack = living.m_21120_(activeHand);
                    return condition.test(handStack);
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("moving"), new SerializableData(), (data, entity) -> ((MovingEntity)entity).isMoving()));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("enchantment"), new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT).add("calculation", SerializableDataTypes.STRING, (Object)"sum"), (data, entity) -> {
            int value = 0;
            if (entity instanceof LivingEntity) {
                String calculation;
                LivingEntity le = (LivingEntity)entity;
                Enchantment enchantment = (Enchantment)data.get("enchantment");
                switch (calculation = data.getString("calculation")) {
                    case "sum": {
                        for (ItemStack stack : enchantment.m_44684_(le).values()) {
                            value += EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
                        }
                        break;
                    }
                    case "max": {
                        value = EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)le);
                        break;
                    }
                    default: {
                        Apoli.LOGGER.error("Error in \"enchantment\" entity condition, undefined calculation type: \"" + calculation + "\".");
                    }
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("riding"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), (data, entity) -> {
            if (entity.m_20159_()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    Entity vehicle = entity.m_20202_();
                    return condition.test(new Tuple(entity, (Object)vehicle));
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("riding_root"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null), (data, entity) -> {
            if (entity.m_20159_()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    Entity vehicle = entity.m_20201_();
                    return condition.test(new Tuple(entity, (Object)vehicle));
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("riding_recursive"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.m_20159_()) {
                Predicate cond = (Predicate)data.get("bientity_condition");
                for (Entity vehicle = entity.m_20202_(); vehicle != null; vehicle = vehicle.m_20202_()) {
                    if (cond != null && !cond.test(new Tuple(entity, (Object)vehicle))) continue;
                    ++count;
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("living"), new SerializableData(), (data, entity) -> entity instanceof LivingEntity));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("passenger"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.m_20160_()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    count = (int)entity.m_20197_().stream().filter(e -> condition.test(new Tuple(e, entity))).count();
                } else {
                    count = entity.m_20197_().size();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("passenger_recursive"), new SerializableData().add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataTypes.INT, (Object)1), (data, entity) -> {
            int count = 0;
            if (entity.m_20160_()) {
                if (data.isPresent("bientity_condition")) {
                    Predicate condition = (Predicate)data.get("bientity_condition");
                    List passengers = entity.m_20197_();
                    count = (int)passengers.stream().flatMap(Entity::m_20199_).filter(e -> condition.test(new Tuple(e, entity))).count();
                } else {
                    count = (int)entity.m_20197_().stream().flatMap(Entity::m_20199_).count();
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(count, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, entity) -> {
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            return NbtUtils.m_129235_((Tag)((Tag)data.get("nbt")), (Tag)nbt, (boolean)true);
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("exists"), new SerializableData(), (data, entity) -> entity != null));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("creative_flying"), new SerializableData(), (data, entity) -> entity instanceof Player && ((Player)entity).m_150110_().f_35935_));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("power_type"), new SerializableData().add("power_type", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerTypeReference powerTypeReference = (PowerTypeReference)data.get("power_type");
            PowerType powerType = powerTypeReference.getReferencedPowerType();
            return PowerHolderComponent.KEY.maybeGet(entity).map(phc -> phc.getPowerTypes(true).contains(powerType)).orElse(false);
        }));
        EntityConditions.register(new ConditionFactory<Entity>(Apoli.identifier("ability"), new SerializableData().add("ability", ApoliDataTypes.PLAYER_ABILITY), (data, entity) -> {
            if (entity instanceof Player && !entity.m_9236_().f_46443_) {
                return ((PlayerAbility)data.get("ability")).isEnabledFor((Player)entity);
            }
            return false;
        }));
        EntityConditions.register(RaycastCondition.getFactory());
        EntityConditions.register(ElytraFlightPossibleCondition.getFactory());
        EntityConditions.register(InventoryCondition.getFactory());
    }

    private static void register(ConditionFactory<Entity> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.ENTITY_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

