/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;

public class DistanceFromCoordinatesConditionRegistry {
    private static final ArrayList<Object> previousWarnings = new ArrayList();

    private static void warnOnce(String warning, Object key) {
        if (!previousWarnings.contains(key)) {
            previousWarnings.add(key);
            Apoli.LOGGER.warn(warning);
        }
    }

    private static void warnOnce(String warning) {
        DistanceFromCoordinatesConditionRegistry.warnOnce(warning, warning);
    }

    private static <T> T warnCouldNotGetObject(String object, String from, T assumption) {
        DistanceFromCoordinatesConditionRegistry.warnOnce("Could not retrieve " + object + " from " + from + " for distance_from_spawn condition, assuming " + String.valueOf(assumption) + " for condition.");
        return assumption;
    }

    private static String[] getAliases() {
        return new String[]{"distance_from_spawn", "distance_from_coordinates"};
    }

    private static SerializableData getSerializableData(String alias) {
        return new SerializableData().add("reference", SerializableDataTypes.STRING, (Object)(alias.equals("distance_from_coordinates") ? "world_origin" : "world_spawn")).add("offset", SerializableDataTypes.VECTOR, (Object)new Vec3(0.0, 0.0, 0.0)).add("coordinates", SerializableDataTypes.VECTOR, (Object)new Vec3(0.0, 0.0, 0.0)).add("ignore_x", SerializableDataTypes.BOOLEAN, (Object)false).add("ignore_y", SerializableDataTypes.BOOLEAN, (Object)false).add("ignore_z", SerializableDataTypes.BOOLEAN, (Object)false).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE).add("scale_reference_to_dimension", SerializableDataTypes.BOOLEAN, (Object)true).add("scale_distance_to_dimension", SerializableDataTypes.BOOLEAN, (Object)false).add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE).add("result_on_wrong_dimension", SerializableDataTypes.BOOLEAN, null).add("round_to_digit", SerializableDataTypes.INT, null);
    }

    private static boolean compareOutOfBounds(Comparison comparison) {
        return comparison == Comparison.NOT_EQUAL || comparison == Comparison.GREATER_THAN || comparison == Comparison.GREATER_THAN_OR_EQUAL;
    }

    private static boolean testCondition(SerializableData.Instance data, BlockInWorld block, Entity entity) {
        double zDistance;
        Level world;
        Vec3 pos;
        boolean scaleReferenceToDimension = data.getBoolean("scale_reference_to_dimension");
        boolean setResultOnWrongDimension = data.isPresent("result_on_wrong_dimension");
        boolean resultOnWrongDimension = setResultOnWrongDimension && data.getBoolean("result_on_wrong_dimension");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (block != null) {
            BlockPos blockPos = block.m_61176_();
            pos = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            LevelReader worldView = block.m_61175_();
            if (!(worldView instanceof Level)) {
                return DistanceFromCoordinatesConditionRegistry.warnCouldNotGetObject("world", "block", DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison"))));
            }
            world = (Level)worldView;
        } else {
            pos = entity.m_20182_();
            world = entity.m_20193_();
        }
        double currentDimensionCoordinateScale = world.m_6042_().f_63859_();
        switch (data.getString("reference")) {
            case "player_spawn": 
            case "player_natural_spawn": {
                if (entity instanceof Player) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used reference '" + data.getString("reference") + "' which is not implemented yet, defaulting to world spawn.");
                }
                if (entity == null) {
                    DistanceFromCoordinatesConditionRegistry.warnOnce("Used entity-condition-only reference point in block condition, defaulting to world spawn.");
                }
            }
            case "world_spawn": {
                BlockPos spawnPos;
                if (setResultOnWrongDimension && world.m_46472_() != Level.f_46428_) {
                    return resultOnWrongDimension;
                }
                if (world instanceof ClientLevel) {
                    spawnPos = ((ClientLevel)world).m_220360_();
                } else if (world instanceof ServerLevel) {
                    spawnPos = ((ServerLevel)world).m_220360_();
                } else {
                    return DistanceFromCoordinatesConditionRegistry.warnCouldNotGetObject("world with spawn position", block != null ? "block" : "entity", DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison"))));
                }
                x = spawnPos.m_123341_();
                y = spawnPos.m_123342_();
                z = spawnPos.m_123343_();
                break;
            }
        }
        Vec3 coords = (Vec3)data.get("coordinates");
        Vec3 offset = (Vec3)data.get("offset");
        y += coords.f_82480_ + offset.f_82480_;
        if (scaleReferenceToDimension && ((x += coords.f_82479_ + offset.f_82479_) != 0.0 || (z += coords.f_82481_ + offset.f_82481_) != 0.0)) {
            if (currentDimensionCoordinateScale == 0.0) {
                return DistanceFromCoordinatesConditionRegistry.compareOutOfBounds((Comparison)((Object)data.get("comparison")));
            }
            x /= currentDimensionCoordinateScale;
            z /= currentDimensionCoordinateScale;
        }
        double xDistance = data.getBoolean("ignore_x") ? 0.0 : Math.abs(pos.m_7096_() - x);
        double yDistance = data.getBoolean("ignore_y") ? 0.0 : Math.abs(pos.m_7098_() - y);
        double d = zDistance = data.getBoolean("ignore_z") ? 0.0 : Math.abs(pos.m_7094_() - z);
        if (data.getBoolean("scale_distance_to_dimension")) {
            xDistance *= currentDimensionCoordinateScale;
            zDistance *= currentDimensionCoordinateScale;
        }
        double distance = Shape.getDistance((Shape)((Object)data.get("shape")), xDistance, yDistance, zDistance);
        if (data.isPresent("round_to_digit")) {
            distance = new BigDecimal(distance).setScale(data.getInt("round_to_digit"), RoundingMode.HALF_UP).doubleValue();
        }
        return ((Comparison)((Object)data.get("comparison"))).compare(distance, data.getDouble("compare_to"));
    }

    public static void registerBlockCondition(Consumer<ConditionFactory<BlockInWorld>> registryFunction) {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            registryFunction.accept(new ConditionFactory<BlockInWorld>(Apoli.identifier(alias), DistanceFromCoordinatesConditionRegistry.getSerializableData(alias), (data, block) -> DistanceFromCoordinatesConditionRegistry.testCondition(data, block, null)));
        }
    }

    public static void registerEntityCondition(Consumer<ConditionFactory<Entity>> registryFunction) {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            registryFunction.accept(new ConditionFactory<Entity>(Apoli.identifier(alias), DistanceFromCoordinatesConditionRegistry.getSerializableData(alias), (data, entity) -> DistanceFromCoordinatesConditionRegistry.testCondition(data, null, entity)));
        }
    }
}

