/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DamageConditions {
    public static void register() {
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, dmg) -> data.getBoolean("value")));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.DAMAGE_CONDITIONS), (data, dmg) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(dmg))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.DAMAGE_CONDITIONS), (data, dmg) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(dmg))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("amount"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, dmg) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Float)dmg.m_14419_()).floatValue(), data.getFloat("compare_to"))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("fire"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268745_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("name"), new SerializableData().add("name", SerializableDataTypes.STRING), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_19385_().equals(data.getString("name"))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("projectile"), new SerializableData().add("projectile", SerializableDataTypes.ENTITY_TYPE, null).add("projectile_condition", ApoliDataTypes.ENTITY_CONDITION, null), (data, dmg) -> {
            Entity projectile;
            if (((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268524_) && (projectile = ((DamageSource)dmg.m_14418_()).m_7640_()) != null) {
                if (data.isPresent("projectile") && projectile.m_6095_() != data.get("projectile")) {
                    return false;
                }
                Predicate projectileCondition = (Predicate)data.get("projectile_condition");
                return projectileCondition == null || projectileCondition.test(projectile);
            }
            return false;
        }));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("attacker"), new SerializableData().add("entity_condition", ApoliDataTypes.ENTITY_CONDITION, null), (data, dmg) -> {
            Entity attacker = ((DamageSource)dmg.m_14418_()).m_7639_();
            if (attacker instanceof LivingEntity && (!data.isPresent("entity_condition") || ((ConditionFactory.Instance)data.get("entity_condition")).test((LivingEntity)attacker))) {
                return true;
            }
            return false;
        }));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("bypasses_armor"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268490_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("explosive"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268415_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("from_falling"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268549_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("unblockable"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_276146_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("out_of_world"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_(DamageTypeTags.f_268738_)));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.tag((ResourceKey)Registries.f_268580_)), (data, dmg) -> ((DamageSource)dmg.m_14418_()).m_269533_((TagKey)data.get("tag"))));
    }

    private static void register(ConditionFactory<Tuple<DamageSource, Float>> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.DAMAGE_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

