/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import com.google.gson.JsonObject;
import io.github.apace100.apoli.power.factory.Factory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ConditionFactory<T>
implements Factory {
    private final ResourceLocation identifier;
    protected SerializableData data;
    private final BiFunction<SerializableData.Instance, T, Boolean> condition;

    public ConditionFactory(ResourceLocation identifier, SerializableData data, BiFunction<SerializableData.Instance, T, Boolean> condition) {
        this.identifier = identifier;
        this.condition = condition;
        this.data = data;
        this.data.add("inverted", SerializableDataTypes.BOOLEAN, (Object)false);
    }

    @Override
    public ResourceLocation getSerializerId() {
        return this.identifier;
    }

    @Override
    public SerializableData getSerializableData() {
        return this.data;
    }

    public Instance read(JsonObject json) {
        return new Instance(this.data.read(json));
    }

    public Instance read(FriendlyByteBuf buffer) {
        return new Instance(this.data.read(buffer));
    }

    public class Instance
    implements Predicate<T> {
        private final SerializableData.Instance dataInstance;

        private Instance(SerializableData.Instance data) {
            this.dataInstance = data;
        }

        @Override
        public final boolean test(T t) {
            boolean fulfilled = this.isFulfilled(t);
            if (this.dataInstance.getBoolean("inverted")) {
                return !fulfilled;
            }
            return fulfilled;
        }

        public boolean isFulfilled(T t) {
            return ConditionFactory.this.condition.apply(this.dataInstance, (SerializableData.Instance)t);
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(ConditionFactory.this.identifier);
            ConditionFactory.this.data.write(buf, this.dataInstance);
        }
    }
}

