/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.bientity.RelativeRotationCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BiEntityConditions {
    public static void register() {
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, pair) -> data.getBoolean("value")));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.BIENTITY_CONDITIONS), (data, pair) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(pair))));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.BIENTITY_CONDITIONS), (data, pair) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(pair))));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("invert"), new SerializableData().add("condition", ApoliDataTypes.BIENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test(new Tuple((Object)((Entity)pair.m_14419_()), (Object)((Entity)pair.m_14418_())));
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("actor_condition"), new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test((Entity)pair.m_14418_());
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("target_condition"), new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test((Entity)pair.m_14419_());
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("either"), new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test((Entity)pair.m_14418_()) || cond.test((Entity)pair.m_14419_());
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("both"), new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test((Entity)pair.m_14418_()) && cond.test((Entity)pair.m_14419_());
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("undirected"), new SerializableData().add("condition", ApoliDataTypes.BIENTITY_CONDITION), (data, pair) -> {
            Predicate cond = (Predicate)data.get("condition");
            return cond.test(pair) || cond.test(new Tuple((Object)((Entity)pair.m_14419_()), (Object)((Entity)pair.m_14418_())));
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("distance"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.DOUBLE), (data, pair) -> {
            double distanceSq = ((Entity)pair.m_14418_()).m_20182_().m_82557_(((Entity)pair.m_14419_()).m_20182_());
            double comp = data.getDouble("compare_to");
            comp *= comp;
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(distanceSq, comp);
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("can_see"), new SerializableData().add("shape_type", SerializableDataType.enumValue(ClipContext.Block.class), (Object)ClipContext.Block.VISUAL).add("fluid_handling", SerializableDataType.enumValue(ClipContext.Fluid.class), (Object)ClipContext.Fluid.NONE), (data, pair) -> {
            ClipContext.Block shapeType = (ClipContext.Block)data.get("shape_type");
            ClipContext.Fluid fluidHandling = (ClipContext.Fluid)data.get("fluid_handling");
            if (((Entity)pair.m_14419_()).m_9236_() != ((Entity)pair.m_14418_()).m_9236_()) {
                return false;
            }
            Vec3 vec3d = new Vec3(((Entity)pair.m_14418_()).m_20185_(), ((Entity)pair.m_14418_()).m_20188_(), ((Entity)pair.m_14418_()).m_20189_());
            Vec3 vec3d2 = new Vec3(((Entity)pair.m_14419_()).m_20185_(), ((Entity)pair.m_14419_()).m_20188_(), ((Entity)pair.m_14419_()).m_20189_());
            if (vec3d2.m_82554_(vec3d) > 128.0) {
                return false;
            }
            return ((Entity)pair.m_14418_()).m_9236_().m_45547_(new ClipContext(vec3d, vec3d2, shapeType, fluidHandling, (Entity)pair.m_14418_())).m_6662_() == HitResult.Type.MISS;
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("owner"), new SerializableData(), (data, pair) -> {
            if (pair.m_14419_() instanceof OwnableEntity) {
                return pair.m_14418_() == ((OwnableEntity)pair.m_14419_()).m_269323_();
            }
            return false;
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("riding"), new SerializableData(), (data, pair) -> ((Entity)pair.m_14418_()).m_20202_() == pair.m_14419_()));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("riding_root"), new SerializableData(), (data, pair) -> ((Entity)pair.m_14418_()).m_20201_() == pair.m_14419_()));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("riding_recursive"), new SerializableData(), (data, pair) -> {
            Entity vehicle;
            if (((Entity)pair.m_14418_()).m_20202_() == null) {
                return false;
            }
            for (vehicle = ((Entity)pair.m_14418_()).m_20202_(); vehicle != pair.m_14419_() && vehicle != null; vehicle = vehicle.m_20202_()) {
            }
            return vehicle == pair.m_14419_();
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("attack_target"), new SerializableData(), (data, pair) -> {
            if (pair.m_14418_() instanceof Mob) {
                return ((Mob)pair.m_14418_()).m_5448_() == pair.m_14419_();
            }
            if (pair.m_14418_() instanceof NeutralMob) {
                return ((NeutralMob)pair.m_14418_()).m_5448_() == pair.m_14419_();
            }
            return false;
        }));
        BiEntityConditions.register(new ConditionFactory<Tuple<Entity, Entity>>(Apoli.identifier("attacker"), new SerializableData(), (data, pair) -> {
            Object patt0$temp = pair.m_14419_();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                return living.m_21188_() == pair.m_14418_();
            }
            return false;
        }));
        BiEntityConditions.register(RelativeRotationCondition.getFactory());
    }

    private static void register(ConditionFactory<Tuple<Entity, Entity>> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.BIENTITY_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

