/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireProjectileAction {
    public static void action(SerializableData.Instance data, Entity entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
        int count = (Integer)data.get("count");
        for (int i = 0; i < count; ++i) {
            EntityType entityType = (EntityType)data.get("entity_type");
            CompoundTag entityNbt = (CompoundTag)data.get("tag");
            float yaw = entity.m_146908_();
            float pitch = entity.m_146909_();
            Optional<Entity> opt$entityToSpawn = MiscUtil.getEntityWithPassengers((Level)serverWorld, entityType, entityNbt, entity.m_20182_().m_82520_(0.0, (double)entity.m_20236_(entity.m_20089_()), 0.0), yaw, pitch);
            if (opt$entityToSpawn.isEmpty()) {
                return;
            }
            Vec3 rotationVector = entity.m_20154_();
            Vec3 velocity = entity.m_20184_();
            Entity entityToSpawn = opt$entityToSpawn.get();
            RandomSource random = serverWorld.m_213780_();
            float divergence = ((Float)data.get("divergence")).floatValue();
            float speed = ((Float)data.get("speed")).floatValue();
            if (entityToSpawn instanceof Projectile) {
                Projectile projectileToSpawn = (Projectile)entityToSpawn;
                if (projectileToSpawn instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile explosiveProjectileToSpawn = (AbstractHurtingProjectile)projectileToSpawn;
                    explosiveProjectileToSpawn.f_36813_ = rotationVector.f_82479_ * (double)speed;
                    explosiveProjectileToSpawn.f_36814_ = rotationVector.f_82480_ * (double)speed;
                    explosiveProjectileToSpawn.f_36815_ = rotationVector.f_82481_ * (double)speed;
                }
                projectileToSpawn.m_5602_(entity);
                projectileToSpawn.m_37251_(entity, pitch, yaw, 0.0f, speed, divergence);
            } else {
                float j = (float)Math.PI / 180;
                double k = 0.0075f;
                float l = -Mth.m_14031_((float)(yaw * j)) * Mth.m_14089_((float)(pitch * j));
                float m = -Mth.m_14031_((float)(pitch * j));
                float n = Mth.m_14089_((float)(yaw * j)) * Mth.m_14089_((float)(pitch * j));
                Vec3 vec3d = new Vec3((double)l, (double)m, (double)n).m_82541_().m_82520_(random.m_188583_() * k * (double)divergence, random.m_188583_() * k * (double)divergence, random.m_188583_() * k * (double)divergence).m_82490_((double)speed);
                entityToSpawn.m_20256_(vec3d);
                entityToSpawn.m_5997_(velocity.f_82479_, entity.m_20096_() ? 0.0 : velocity.f_82480_, velocity.f_82481_);
            }
            serverWorld.m_8860_(entityToSpawn);
            data.ifPresent("projectile_action", projectileAction -> projectileAction.accept(entityToSpawn));
        }
    }

    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory<Entity>(Apoli.identifier("fire_projectile"), new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("count", SerializableDataTypes.INT, (Object)1).add("tag", SerializableDataTypes.NBT, null).add("projectile_action", ApoliDataTypes.ENTITY_ACTION, null), FireProjectileAction::action);
    }
}

