/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.bientity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DamageAction {
    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        Entity actor = (Entity)entities.m_14418_();
        Entity target = (Entity)entities.m_14419_();
        if (actor == null || target == null) {
            return;
        }
        Float damageAmount = (Float)data.get("amount");
        LinkedList<Modifier> modifiers = new LinkedList<Modifier>();
        data.ifPresent("modifier", modifiers::add);
        data.ifPresent("modifiers", modifiers::addAll);
        if (!modifiers.isEmpty() && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            damageAmount = Float.valueOf((float)ModifierUtil.applyModifiers(actor, modifiers, (double)livingTarget.m_21233_()));
        }
        if (damageAmount == null) {
            return;
        }
        try {
            DamageSource damageSource = MiscUtil.createDamageSource(actor.m_269291_(), (DamageSourceDescription)data.get("source"), (ResourceKey<DamageType>)((ResourceKey)data.get("damage_type")), actor);
            target.m_6469_(damageSource, damageAmount.floatValue());
        }
        catch (Throwable t) {
            Apoli.LOGGER.error("Error trying to deal damage via the `damage` bi-entity action: " + t.getMessage());
        }
    }

    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory<Tuple<Entity, Entity>>(Apoli.identifier("damage"), new SerializableData().add("amount", SerializableDataTypes.FLOAT, null).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), DamageAction::action);
    }
}

