/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.NamespaceAlias;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ActionType<T> {
    private final String actionTypeName;
    private final Registry<ActionFactory<T>> actionFactoryRegistry;

    public ActionType(String actionTypeName, Registry<ActionFactory<T>> actionFactoryRegistry) {
        this.actionTypeName = actionTypeName;
        this.actionFactoryRegistry = actionFactoryRegistry;
    }

    public void write(FriendlyByteBuf buf, ActionFactory.Instance actionInstance) {
        actionInstance.write(buf);
    }

    public ActionFactory.Instance read(FriendlyByteBuf buf) {
        ResourceLocation type = buf.m_130281_();
        ActionFactory actionFactory = (ActionFactory)this.actionFactoryRegistry.m_7745_(type);
        if (actionFactory == null) {
            throw new JsonSyntaxException(this.actionTypeName + " \"" + String.valueOf(type) + "\" was not registered.");
        }
        return actionFactory.read(buf);
    }

    public ActionFactory.Instance read(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (!obj.has("type")) {
                throw new JsonSyntaxException(this.actionTypeName + " json requires \"type\" identifier.");
            }
            String typeIdentifier = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            ResourceLocation type = ResourceLocation.m_135820_((String)typeIdentifier);
            Optional optionalAction = this.actionFactoryRegistry.m_6612_(type);
            if (!optionalAction.isPresent()) {
                if (NamespaceAlias.hasAlias(type)) {
                    optionalAction = this.actionFactoryRegistry.m_6612_(NamespaceAlias.resolveAlias(type));
                }
                if (!optionalAction.isPresent()) {
                    throw new JsonSyntaxException(this.actionTypeName + " json type \"" + type.toString() + "\" is not defined.");
                }
            }
            return ((ActionFactory)optionalAction.get()).read(obj);
        }
        throw new JsonSyntaxException(this.actionTypeName + " has to be a JsonObject!");
    }
}

