/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory;

import com.google.gson.JsonObject;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.Factory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class PowerFactory<P extends Power>
implements Factory {
    private final ResourceLocation id;
    private boolean hasConditions = false;
    protected SerializableData data;
    protected Function<SerializableData.Instance, BiFunction<PowerType<P>, LivingEntity, P>> factoryConstructor;

    public PowerFactory(ResourceLocation id, SerializableData data, Function<SerializableData.Instance, BiFunction<PowerType<P>, LivingEntity, P>> factoryConstructor) {
        this.id = id;
        this.data = data;
        this.factoryConstructor = factoryConstructor;
    }

    public PowerFactory<P> allowCondition() {
        if (!this.hasConditions) {
            this.hasConditions = true;
            this.data.add("condition", ApoliDataTypes.ENTITY_CONDITION, null);
        }
        return this;
    }

    @Override
    public ResourceLocation getSerializerId() {
        return this.id;
    }

    @Override
    public SerializableData getSerializableData() {
        return this.data;
    }

    public Instance read(JsonObject json) {
        return new Instance(this.data.read(json));
    }

    public Instance read(FriendlyByteBuf buffer) {
        return new Instance(this.data.read(buffer));
    }

    public class Instance
    implements BiFunction<PowerType<P>, LivingEntity, P> {
        private final SerializableData.Instance dataInstance;

        private Instance(SerializableData.Instance data) {
            this.dataInstance = data;
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(PowerFactory.this.id);
            PowerFactory.this.data.write(buf, this.dataInstance);
        }

        @Override
        public P apply(PowerType<P> pPowerType, LivingEntity livingEntity) {
            BiFunction powerFactory = PowerFactory.this.factoryConstructor.apply(this.dataInstance);
            Power p = (Power)powerFactory.apply(pPowerType, livingEntity);
            if (PowerFactory.this.hasConditions && this.dataInstance.isPresent("condition")) {
                p.addCondition((ConditionFactory.Instance)this.dataInstance.get("condition"));
            }
            return p;
        }

        public SerializableData.Instance getDataInstance() {
            return this.dataInstance;
        }

        public PowerFactory<?> getFactory() {
            return PowerFactory.this;
        }
    }
}

