/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class StatusEffectPower
extends Power {
    protected final List<MobEffectInstance> effects = new LinkedList<MobEffectInstance>();

    public StatusEffectPower(PowerType<?> type, LivingEntity entity) {
        super(type, entity);
    }

    public StatusEffectPower(PowerType<?> type, LivingEntity entity, MobEffectInstance effectInstance) {
        super(type, entity);
        this.addEffect(effectInstance);
    }

    public StatusEffectPower addEffect(MobEffect effect) {
        return this.addEffect(effect, 80);
    }

    public StatusEffectPower addEffect(MobEffect effect, int lingerDuration) {
        return this.addEffect(effect, lingerDuration, 0);
    }

    public StatusEffectPower addEffect(MobEffect effect, int lingerDuration, int amplifier) {
        return this.addEffect(new MobEffectInstance(effect, lingerDuration, amplifier));
    }

    public StatusEffectPower addEffect(MobEffectInstance instance) {
        this.effects.add(instance);
        return this;
    }

    public void applyEffects() {
        this.effects.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)this.entity).m_7292_(arg_0));
    }
}

