/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.StatusEffectPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class StackingStatusEffectPower
extends StatusEffectPower {
    private final int minStack;
    private final int maxStack;
    private final int durationPerStack;
    private final int tickRate;
    private int currentStack;

    public StackingStatusEffectPower(PowerType<?> type, LivingEntity entity, int minStack, int maxStack, int durationPerStack, int tickRate) {
        super(type, entity);
        this.minStack = minStack;
        this.maxStack = maxStack;
        this.durationPerStack = durationPerStack;
        this.tickRate = tickRate;
        this.setTicking(true);
    }

    @Override
    public void tick() {
        if (this.entity.f_19797_ % this.tickRate == 0) {
            if (this.isActive()) {
                ++this.currentStack;
                if (this.currentStack > this.maxStack) {
                    this.currentStack = this.maxStack;
                }
                if (this.currentStack > 0) {
                    this.applyEffects();
                }
            } else {
                --this.currentStack;
                if (this.currentStack < this.minStack) {
                    this.currentStack = this.minStack;
                }
            }
        }
    }

    @Override
    public void applyEffects() {
        this.effects.forEach(sei -> {
            int duration = this.durationPerStack * this.currentStack;
            if (duration > 0) {
                MobEffectInstance applySei = new MobEffectInstance(sei.m_19544_(), duration, sei.m_19564_(), sei.m_19571_(), sei.m_19572_(), sei.m_19575_());
                this.entity.m_7292_(applySei);
            }
        });
    }

    @Override
    public Tag toTag() {
        return IntTag.m_128679_((int)this.currentStack);
    }

    @Override
    public void fromTag(Tag tag) {
        this.currentStack = ((IntTag)tag).m_7047_();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("stacking_status_effect"), new SerializableData().add("min_stacks", SerializableDataTypes.INT).add("max_stacks", SerializableDataTypes.INT).add("duration_per_stack", SerializableDataTypes.INT).add("tick_rate", SerializableDataTypes.INT, (Object)10).add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), data -> (type, player) -> {
            StackingStatusEffectPower power = new StackingStatusEffectPower((PowerType<?>)type, (LivingEntity)player, data.getInt("min_stacks"), data.getInt("max_stacks"), data.getInt("duration_per_stack"), data.getInt("tick_rate"));
            if (data.isPresent("effect")) {
                power.addEffect((MobEffectInstance)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                ((List)data.get("effects")).forEach(power::addEffect);
            }
            return power;
        }).allowCondition();
    }
}

