/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SelfGlowPower
extends Power {
    private final Predicate<Entity> entityCondition;
    private final Predicate<Tuple<Entity, Entity>> bientityCondition;
    private final boolean useTeams;
    private final float red;
    private final float green;
    private final float blue;

    public SelfGlowPower(PowerType<?> type, LivingEntity entity, Predicate<Entity> entityCondition, Predicate<Tuple<Entity, Entity>> bientityCondition, boolean useTeams, float red, float green, float blue) {
        super(type, entity);
        this.entityCondition = entityCondition;
        this.bientityCondition = bientityCondition;
        this.useTeams = useTeams;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public boolean doesApply(Entity e) {
        return !(this.entityCondition != null && !this.entityCondition.test(e) || this.bientityCondition != null && !this.bientityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)e, (Object)this.entity)));
    }

    public boolean usesTeams() {
        return this.useTeams;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("self_glow"), new SerializableData().add("entity_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("use_teams", SerializableDataTypes.BOOLEAN, (Object)true).add("red", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("green", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("blue", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), data -> (type, player) -> new SelfGlowPower((PowerType<?>)type, (LivingEntity)player, (ConditionFactory.Instance)data.get("entity_condition"), (ConditionFactory.Instance)data.get("bientity_condition"), data.getBoolean("use_teams"), data.getFloat("red"), data.getFloat("green"), data.getFloat("blue"))).allowCondition();
    }
}

