/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface Prioritized<T extends Power> {
    public int getPriority();

    public static class CallInstance<T extends Power> {
        private final HashMap<Integer, List<T>> buckets = new HashMap();
        private int minPriority = Integer.MAX_VALUE;
        private int maxPriority = Integer.MIN_VALUE;

        public <U extends T> void add(LivingEntity entity, Class<U> cls) {
            this.add((Entity)entity, cls, null);
        }

        public <U extends T> void add(Entity entity, Class<U> cls, Predicate<U> filter) {
            Stream stream = PowerHolderComponent.getPowers(entity, cls).stream();
            if (filter != null) {
                stream = stream.filter(filter);
            }
            stream.forEach(x$0 -> this.add(x$0));
        }

        public int getMinPriority() {
            return this.minPriority;
        }

        public int getMaxPriority() {
            return this.maxPriority;
        }

        public boolean hasPowers(int priority) {
            return this.buckets.containsKey(priority);
        }

        public List<T> getPowers(int priority) {
            if (this.buckets.containsKey(priority)) {
                return this.buckets.get(priority);
            }
            return new LinkedList();
        }

        public void add(T t) {
            int priority = ((Prioritized)t).getPriority();
            if (this.buckets.containsKey(priority)) {
                this.buckets.get(priority).add(t);
            } else {
                LinkedList<T> list = new LinkedList<T>();
                list.add(t);
                this.buckets.put(priority, list);
            }
            if (priority < this.minPriority) {
                this.minPriority = priority;
            }
            if (priority > this.maxPriority) {
                this.maxPriority = priority;
            }
        }
    }
}

