/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.AdditionalPowerDataCallback;
import io.github.apace100.apoli.integration.PostPowerLoadCallback;
import io.github.apace100.apoli.integration.PostPowerReloadCallback;
import io.github.apace100.apoli.integration.PowerReloadCallback;
import io.github.apace100.apoli.integration.PrePowerLoadCallback;
import io.github.apace100.apoli.integration.PrePowerReloadCallback;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.ApoliResourceConditions;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.calio.data.MultiJsonDataLoader;
import io.github.apace100.calio.data.SerializableData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class PowerTypes
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final Set<ResourceLocation> DEPENDENCIES = new HashSet<ResourceLocation>();
    public static final Set<String> LOADED_NAMESPACES = new HashSet<String>();
    private static final ResourceLocation MULTIPLE = Apoli.identifier("multiple");
    private static final ResourceLocation SIMPLE = Apoli.identifier("simple");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final HashMap<ResourceLocation, Integer> LOADING_PRIORITIES = new HashMap();
    private static final HashMap<String, AdditionalPowerDataCallback> ADDITIONAL_DATA = new HashMap();

    public PowerTypes() {
        super(GSON, "powers");
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> loader, ResourceManager manager, ProfilerFiller profiler) {
        PowerTypeRegistry.reset();
        LOADING_PRIORITIES.clear();
        LOADED_NAMESPACES.clear();
        LOADED_NAMESPACES.addAll(manager.m_7187_());
        ((PowerReloadCallback)PowerReloadCallback.EVENT.invoker()).onPowerReload();
        ((PrePowerReloadCallback)PrePowerReloadCallback.EVENT.invoker()).onPrePowerReload();
        loader.forEach((id, jel) -> {
            for (JsonElement je : jel) {
                try {
                    SerializableData.CURRENT_NAMESPACE = id.m_135827_();
                    SerializableData.CURRENT_PATH = id.m_135815_();
                    JsonObject jo = je.getAsJsonObject();
                    ((PrePowerLoadCallback)PrePowerLoadCallback.EVENT.invoker()).onPrePowerLoad((ResourceLocation)id, jo);
                    ResourceLocation factoryId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jo, (String)"type"));
                    if (this.isMultiple(factoryId)) {
                        LinkedList<ResourceLocation> subPowers = new LinkedList<ResourceLocation>();
                        for (Map.Entry entry : jo.entrySet()) {
                            if (((String)entry.getKey()).equals("type") || ((String)entry.getKey()).equals("loading_priority") || ((String)entry.getKey()).equals("name") || ((String)entry.getKey()).equals("description") || ((String)entry.getKey()).equals("hidden") || ((String)entry.getKey()).equals("condition") || ((String)entry.getKey()).startsWith("$") || ADDITIONAL_DATA.containsKey(entry.getKey()) || ((String)entry.getKey()).equals("fabric:load_conditions")) continue;
                            ResourceLocation subId = new ResourceLocation(String.valueOf(id) + "_" + (String)entry.getKey());
                            try {
                                PowerType subPower = this.readPower(subId, (JsonElement)entry.getValue(), true);
                                if (subPower == null) continue;
                                subPowers.add(subId);
                            }
                            catch (Exception e) {
                                Apoli.LOGGER.error("There was a problem reading sub-power \"" + String.valueOf(subId) + "\" in power file \"" + String.valueOf(id) + "\": " + e.getMessage());
                            }
                        }
                        MultiplePowerType superPower = (MultiplePowerType)this.readPower((ResourceLocation)id, je, false, MultiplePowerType::new);
                        if (superPower != null) {
                            superPower.setSubPowers(subPowers);
                        } else {
                            subPowers.forEach(PowerTypeRegistry::disable);
                        }
                        this.handleAdditionalData((ResourceLocation)id, factoryId, false, jo, superPower);
                        ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad((ResourceLocation)id, factoryId, false, jo, superPower);
                        continue;
                    }
                    this.readPower((ResourceLocation)id, je, false);
                }
                catch (Exception e) {
                    Apoli.LOGGER.error("There was a problem reading power file " + id.toString() + " (skipping): " + e.getMessage());
                }
            }
        });
        ((PostPowerReloadCallback)PostPowerReloadCallback.EVENT.invoker()).onPostPowerReload();
        LOADING_PRIORITIES.clear();
        LOADED_NAMESPACES.clear();
        SerializableData.CURRENT_NAMESPACE = null;
        SerializableData.CURRENT_PATH = null;
        Apoli.LOGGER.info("Finished loading powers from data files. Registry contains " + PowerTypeRegistry.size() + " powers.");
    }

    private boolean isResourceConditionValid(ResourceLocation id, JsonObject jo) {
        return ApoliResourceConditions.test(id, jo);
    }

    @Nullable
    private PowerType readPower(ResourceLocation id, JsonElement je, boolean isSubPower) {
        return this.readPower(id, je, isSubPower, PowerType::new);
    }

    @Nullable
    private PowerType readPower(ResourceLocation id, JsonElement je, boolean isSubPower, BiFunction<ResourceLocation, PowerFactory.Instance, PowerType> powerTypeFactory) {
        Optional optionalFactory;
        JsonObject jo = je.getAsJsonObject();
        ResourceLocation factoryId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jo, (String)"type"));
        int priority = GsonHelper.m_13824_((JsonObject)jo, (String)"loading_priority", (int)0);
        if (!this.isResourceConditionValid(id, jo)) {
            if (!PowerTypeRegistry.contains(id)) {
                PowerTypeRegistry.disable(id);
            }
            return null;
        }
        if (this.isMultiple(factoryId)) {
            factoryId = SIMPLE;
            if (isSubPower) {
                throw new JsonSyntaxException("Power type \"" + String.valueOf(MULTIPLE) + "\" may not be used for a sub-power of another \"" + String.valueOf(MULTIPLE) + "\" power.");
            }
        }
        if ((optionalFactory = ApoliRegistries.POWER_FACTORY.m_6612_(factoryId)).isEmpty()) {
            if (NamespaceAlias.hasAlias(factoryId)) {
                optionalFactory = ApoliRegistries.POWER_FACTORY.m_6612_(NamespaceAlias.resolveAlias(factoryId));
            }
            if (optionalFactory.isEmpty()) {
                throw new JsonSyntaxException("Power type \"" + String.valueOf(factoryId) + "\" is not defined.");
            }
        }
        PowerFactory.Instance factoryInstance = ((PowerFactory)optionalFactory.get()).read(jo);
        PowerType type = powerTypeFactory.apply(id, factoryInstance);
        String name = GsonHelper.m_13851_((JsonObject)jo, (String)"name", (String)"");
        String description = GsonHelper.m_13851_((JsonObject)jo, (String)"description", (String)"");
        boolean hidden = GsonHelper.m_13855_((JsonObject)jo, (String)"hidden", (boolean)false);
        if (hidden || isSubPower) {
            type.setHidden();
        }
        type.setTranslationKeys(name, description);
        if (!PowerTypeRegistry.contains(id)) {
            PowerTypeRegistry.register(id, type);
            LOADING_PRIORITIES.put(id, priority);
            if (!(type instanceof MultiplePowerType)) {
                this.handleAdditionalData(id, factoryId, isSubPower, jo, type);
                ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad(id, factoryId, isSubPower, jo, type);
            }
        } else if (LOADING_PRIORITIES.get(id) < priority) {
            PowerTypeRegistry.update(id, type);
            LOADING_PRIORITIES.put(id, priority);
            if (!(type instanceof MultiplePowerType)) {
                this.handleAdditionalData(id, factoryId, isSubPower, jo, type);
                ((PostPowerLoadCallback)PostPowerLoadCallback.EVENT.invoker()).onPostPowerLoad(id, factoryId, isSubPower, jo, type);
            }
        }
        return type;
    }

    private boolean isMultiple(ResourceLocation id) {
        if (MULTIPLE.equals((Object)id)) {
            return true;
        }
        if (NamespaceAlias.hasAlias(id)) {
            return MULTIPLE.equals((Object)NamespaceAlias.resolveAlias(id));
        }
        return false;
    }

    private void handleAdditionalData(ResourceLocation powerId, ResourceLocation factoryId, boolean isSubPower, JsonObject json, PowerType<?> powerType) {
        ADDITIONAL_DATA.forEach((dataFieldName, callback) -> {
            if (json.has(dataFieldName)) {
                callback.readAdditionalPowerData(powerId, factoryId, isSubPower, json.get(dataFieldName), powerType);
            }
        });
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("apoli", "powers");
    }

    public static void registerAdditionalData(String data, AdditionalPowerDataCallback callback) {
        if (ADDITIONAL_DATA.containsKey(data)) {
            Apoli.LOGGER.error("Apoli already contains a callback for additional data for the field \"" + data + "\".");
            return;
        }
        ADDITIONAL_DATA.put(data, callback);
    }

    public static int getLoadingPriority(ResourceLocation powerId) {
        if (!LOADING_PRIORITIES.containsKey(powerId)) {
            return Integer.MIN_VALUE;
        }
        return LOADING_PRIORITIES.get(powerId);
    }

    public Collection<ResourceLocation> getFabricDependencies() {
        return DEPENDENCIES;
    }
}

