/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.PlayerAbility;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerAbilityPower
extends Power {
    private final PlayerAbility ability;
    private final AbilitySource source;

    public PlayerAbilityPower(PowerType<?> type, LivingEntity entity, PlayerAbility playerAbility) {
        super(type, entity);
        this.ability = playerAbility;
        if (entity instanceof Player) {
            this.setTicking(true);
        }
        this.source = Pal.getAbilitySource((ResourceLocation)type.getIdentifier());
    }

    @Override
    public void tick() {
        if (!this.entity.m_9236_().f_46443_) {
            boolean isActive = this.isActive();
            boolean hasAbility = this.hasAbility();
            if (isActive && !hasAbility) {
                this.grantAbility();
            } else if (!isActive && hasAbility) {
                this.revokeAbility();
            }
        }
    }

    @Override
    public void onGained() {
        if (!this.entity.m_9236_().f_46443_ && this.entity instanceof Player && this.isActive() && !this.hasAbility()) {
            this.grantAbility();
        }
    }

    @Override
    public void onAdded() {
        Player player;
        LivingEntity livingEntity;
        if (!this.entity.m_9236_().f_46443_ && (livingEntity = this.entity) instanceof Player && Apoli.LEGACY_POWER_SOURCE.grants(player = (Player)livingEntity, this.ability)) {
            Apoli.LEGACY_POWER_SOURCE.revokeFrom(player, this.ability);
        }
    }

    @Override
    public void onLost() {
        if (!this.entity.m_9236_().f_46443_ && this.entity instanceof Player && this.hasAbility()) {
            this.revokeAbility();
        }
    }

    public boolean hasAbility() {
        return this.source.grants((Player)this.entity, this.ability);
    }

    public void grantAbility() {
        this.source.grantTo((Player)this.entity, this.ability);
    }

    public void revokeAbility() {
        this.source.revokeFrom((Player)this.entity, this.ability);
    }

    public static PowerFactory createAbilityFactory(ResourceLocation identifier, PlayerAbility ability) {
        return new PowerFactory(identifier, new SerializableData(), data -> (type, player) -> new PlayerAbilityPower((PowerType<?>)type, (LivingEntity)player, ability)).allowCondition();
    }
}

