/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class OverlayPower
extends Power {
    private final ResourceLocation texture;
    private final float strength;
    private final float red;
    private final float green;
    private final float blue;
    private final DrawMode drawMode;
    private final DrawPhase drawPhase;
    private final boolean hideWithHud;
    private final boolean visibleInThirdPerson;

    public OverlayPower(PowerType<?> type, LivingEntity entity, ResourceLocation texture, float strength, float red, float green, float blue, DrawMode drawMode, DrawPhase drawPhase, boolean hideWithHud, boolean visibleInThirdPerson) {
        super(type, entity);
        this.texture = texture;
        this.strength = strength;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.drawMode = drawMode;
        this.drawPhase = drawPhase;
        this.hideWithHud = hideWithHud;
        this.visibleInThirdPerson = visibleInThirdPerson;
    }

    public DrawPhase getDrawPhase() {
        return this.drawPhase;
    }

    public boolean shouldBeVisibleInThirdPerson() {
        return this.visibleInThirdPerson;
    }

    public boolean doesHideWithHud() {
        return this.hideWithHud;
    }

    @Environment(value=EnvType.CLIENT)
    public void render() {
        float a;
        double n;
        double m;
        double l;
        double e;
        float k;
        float h;
        float g;
        Minecraft client = Minecraft.m_91087_();
        int i = client.m_91268_().m_85445_();
        int j = client.m_91268_().m_85446_();
        switch (this.drawMode.ordinal()) {
            case 0: {
                double d = Mth.m_14139_((double)this.strength, (double)2.0, (double)1.0);
                g = this.red * this.strength;
                h = this.green * this.strength;
                k = this.blue * this.strength;
                e = (double)i * d;
                l = (double)j * d;
                m = ((double)i - e) / 2.0;
                n = ((double)j - l) / 2.0;
                a = 1.0f;
                break;
            }
            default: {
                g = this.red;
                h = this.green;
                k = this.blue;
                a = this.strength;
                e = i;
                l = j;
                m = 0.0;
                n = 0.0;
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        switch (this.drawMode.ordinal()) {
            case 0: {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            default: {
                RenderSystem.defaultBlendFunc();
            }
        }
        RenderSystem.setShaderColor((float)g, (float)h, (float)k, (float)a);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(m, n + l, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(m + e, n + l, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(m + e, n, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_(m, n, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("overlay"), new SerializableData().add("texture", SerializableDataTypes.IDENTIFIER).add("strength", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("red", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("green", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("blue", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("draw_mode", SerializableDataType.enumValue(DrawMode.class)).add("draw_phase", SerializableDataType.enumValue(DrawPhase.class)).add("hide_with_hud", SerializableDataTypes.BOOLEAN, (Object)true).add("visible_in_third_person", SerializableDataTypes.BOOLEAN, (Object)false), data -> (type, player) -> new OverlayPower((PowerType<?>)type, (LivingEntity)player, data.getId("texture"), data.getFloat("strength"), data.getFloat("red"), data.getFloat("green"), data.getFloat("blue"), (DrawMode)((Object)((Object)((Object)data.get("draw_mode")))), (DrawPhase)((Object)((Object)((Object)data.get("draw_phase")))), data.getBoolean("hide_with_hud"), data.getBoolean("visible_in_third_person"))).allowCondition();
    }

    public static enum DrawMode {
        NAUSEA,
        TEXTURE;

    }

    public static enum DrawPhase {
        BELOW_HUD,
        ABOVE_HUD;

    }
}

