/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class ModifyStatusEffectDurationPower
extends ValueModifyingPower {
    private final List<MobEffect> statusEffects;

    public ModifyStatusEffectDurationPower(PowerType<?> type, LivingEntity entity, List<MobEffect> statusEffects) {
        super(type, entity);
        this.statusEffects = statusEffects;
    }

    public boolean doesApply(MobEffect statusEffect) {
        return this.statusEffects == null || this.statusEffects.contains(statusEffect);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_status_effect_duration"), new SerializableData().add("status_effect", SerializableDataTypes.STATUS_EFFECT, null).add("status_effects", SerializableDataTypes.STATUS_EFFECTS, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), data -> (type, player) -> {
            LinkedList<MobEffect> statusEffects = new LinkedList<MobEffect>();
            data.ifPresent("status_effect", statusEffects::add);
            data.ifPresent("status_effects", statusEffects::addAll);
            ModifyStatusEffectDurationPower power = new ModifyStatusEffectDurationPower((PowerType<?>)type, (LivingEntity)player, (List<MobEffect>)(data.isPresent("status_effect") || data.isPresent("status_effects") ? statusEffects : null));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", l -> l.forEach(power::addModifier));
            return power;
        }).allowCondition();
    }
}

