/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.tuple.Triple;

public class ModifyGrindstonePower
extends Power {
    private final Predicate<ItemStack> topItemCondition;
    private final Predicate<ItemStack> bottomItemCondition;
    private final Predicate<ItemStack> outputItemCondition;
    private final Predicate<BlockInWorld> blockCondition;
    private final ItemStack newResultStack;
    private final Consumer<Tuple<Level, ItemStack>> resultItemAction;
    private final Consumer<Tuple<Level, ItemStack>> lateItemAction;
    private final Consumer<Entity> entityAction;
    private final Consumer<Triple<Level, BlockPos, Direction>> blockAction;
    private final ResultType resultType;
    private final Modifier experienceModifier;

    public ModifyGrindstonePower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> topItemCondition, Predicate<ItemStack> bottomItemCondition, Predicate<ItemStack> outputItemCondition, Predicate<BlockInWorld> blockCondition, ItemStack newResultStack, Consumer<Tuple<Level, ItemStack>> resultItemAction, Consumer<Tuple<Level, ItemStack>> lateItemAction, Consumer<Entity> entityAction, Consumer<Triple<Level, BlockPos, Direction>> blockAction, ResultType resultType, Modifier experienceModifier) {
        super(type, entity);
        this.topItemCondition = topItemCondition;
        this.bottomItemCondition = bottomItemCondition;
        this.outputItemCondition = outputItemCondition;
        this.blockCondition = blockCondition;
        this.newResultStack = newResultStack;
        this.resultItemAction = resultItemAction;
        this.lateItemAction = lateItemAction;
        this.entityAction = entityAction;
        this.blockAction = blockAction;
        this.resultType = resultType;
        this.experienceModifier = experienceModifier;
    }

    public boolean allowsInTop(ItemStack inputTop) {
        return this.topItemCondition == null || this.topItemCondition.test(inputTop);
    }

    public boolean allowsInBottom(ItemStack inputBottom) {
        return this.bottomItemCondition == null || this.bottomItemCondition.test(inputBottom);
    }

    public void applyAfterGrindingItemAction(ItemStack output) {
        if (this.lateItemAction == null) {
            return;
        }
        this.lateItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)output));
    }

    public boolean doesApply(ItemStack inputTop, ItemStack inputBottom, ItemStack originalOutput, Optional<BlockPos> grindstonePos) {
        if (this.topItemCondition != null && !this.topItemCondition.test(inputTop)) {
            return false;
        }
        if (this.bottomItemCondition != null && !this.bottomItemCondition.test(inputBottom)) {
            return false;
        }
        if (this.outputItemCondition != null && !this.outputItemCondition.test(originalOutput)) {
            return false;
        }
        return this.blockCondition == null || !grindstonePos.isPresent() || this.blockCondition.test(new BlockInWorld((LevelReader)this.entity.m_9236_(), grindstonePos.get(), true));
    }

    public Modifier getExperienceModifier() {
        return this.experienceModifier;
    }

    public ItemStack getOutput(ItemStack inputTop, ItemStack inputBottom, ItemStack currentOutput) {
        ItemStack output = currentOutput.m_41777_();
        switch (this.resultType.ordinal()) {
            case 1: {
                output = this.newResultStack.m_41777_();
                break;
            }
            case 3: {
                output = inputBottom.m_41777_();
                break;
            }
            case 2: {
                output = inputTop.m_41777_();
            }
        }
        if (this.resultItemAction != null) {
            this.resultItemAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)output));
        }
        return output;
    }

    public void executeActions(Optional<BlockPos> pos) {
        if (this.entityAction != null) {
            this.entityAction.accept((Entity)this.entity);
        }
        if (this.blockAction != null && pos.isPresent()) {
            this.blockAction.accept((Triple<Level, BlockPos, Direction>)Triple.of((Object)this.entity.m_9236_(), (Object)pos.get(), (Object)Direction.UP));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_grindstone"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("block_action", ApoliDataTypes.BLOCK_ACTION, null).add("top_condition", ApoliDataTypes.ITEM_CONDITION, null).add("bottom_condition", ApoliDataTypes.ITEM_CONDITION, null).add("output_condition", ApoliDataTypes.ITEM_CONDITION, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("item_action_after_grinding", ApoliDataTypes.ITEM_ACTION, null).add("result_stack", SerializableDataTypes.ITEM_STACK, null).add("result_type", SerializableDataType.enumValue(ResultType.class), (Object)ResultType.UNCHANGED).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("xp_modifier", Modifier.DATA_TYPE, null), data -> (type, player) -> new ModifyGrindstonePower((PowerType<?>)type, (LivingEntity)player, (Predicate)data.get("top_condition"), (Predicate)data.get("bottom_condition"), (Predicate)data.get("output_condition"), (Predicate)data.get("block_condition"), (ItemStack)data.get("result_stack"), (Consumer)data.get("item_action"), (Consumer)data.get("item_action_after_grinding"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"), (ResultType)((Object)((Object)((Object)data.get("result_type")))), (Modifier)data.get("xp_modifier")));
    }

    private static enum ResultType {
        UNCHANGED,
        SPECIFIED,
        FROM_TOP,
        FROM_BOTTOM;

    }
}

