/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ModifyFoodPower
extends Power {
    private final Predicate<ItemStack> applicableFood;
    private final ItemStack replaceStack;
    private final Consumer<Tuple<Level, ItemStack>> consumableAction;
    private final List<Modifier> foodModifiers;
    private final List<Modifier> saturationModifiers;
    private final Consumer<Entity> entityActionWhenEaten;
    private final boolean preventFoodEffects;
    private final boolean makeAlwaysEdible;

    public ModifyFoodPower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> applicableFood, ItemStack replaceStack, Consumer<Tuple<Level, ItemStack>> consumableAction, Modifier foodModifier, List<Modifier> foodModifiers, Modifier saturationModifier, List<Modifier> saturationModifiers, Consumer<Entity> entityActionWhenEaten, boolean makeAlwaysEdible, boolean preventFoodEffects) {
        super(type, entity);
        this.applicableFood = applicableFood;
        this.replaceStack = replaceStack;
        this.consumableAction = consumableAction;
        this.foodModifiers = new LinkedList<Modifier>();
        if (foodModifier != null) {
            this.foodModifiers.add(foodModifier);
        }
        if (foodModifiers != null) {
            this.foodModifiers.addAll(foodModifiers);
        }
        this.saturationModifiers = new LinkedList<Modifier>();
        if (saturationModifier != null) {
            this.saturationModifiers.add(saturationModifier);
        }
        if (saturationModifiers != null) {
            this.saturationModifiers.addAll(saturationModifiers);
        }
        this.entityActionWhenEaten = entityActionWhenEaten;
        this.makeAlwaysEdible = makeAlwaysEdible;
        this.preventFoodEffects = preventFoodEffects;
    }

    public boolean doesApply(ItemStack stack) {
        return this.applicableFood == null || this.applicableFood.test(stack);
    }

    public ItemStack getConsumedItemStack(ItemStack stack) {
        if (this.replaceStack != null) {
            stack = this.replaceStack;
        }
        ItemStack consumed = stack.m_41777_();
        if (this.consumableAction != null) {
            this.consumableAction.accept((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)consumed));
        }
        return consumed;
    }

    public void eat() {
        if (this.entityActionWhenEaten != null) {
            this.entityActionWhenEaten.accept((Entity)this.entity);
        }
    }

    public List<Modifier> getFoodModifiers() {
        return this.foodModifiers;
    }

    public List<Modifier> getSaturationModifiers() {
        return this.saturationModifiers;
    }

    public boolean doesMakeAlwaysEdible() {
        return this.makeAlwaysEdible;
    }

    public boolean doesPreventEffects() {
        return this.preventFoodEffects;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_food"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("replace_stack", SerializableDataTypes.ITEM_STACK, null).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("food_modifier", Modifier.DATA_TYPE, null).add("food_modifiers", Modifier.LIST_TYPE, null).add("saturation_modifier", Modifier.DATA_TYPE, null).add("saturation_modifiers", Modifier.LIST_TYPE, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("always_edible", SerializableDataTypes.BOOLEAN, (Object)false).add("prevent_effects", SerializableDataTypes.BOOLEAN, (Object)false), data -> (powerType, livingEntity) -> new ModifyFoodPower((PowerType<?>)powerType, (LivingEntity)livingEntity, (Predicate)data.get("item_condition"), (ItemStack)data.get("replace_stack"), (Consumer)data.get("item_action"), (Modifier)data.get("food_modifier"), (List)data.get("food_modifiers"), (Modifier)data.get("saturation_modifier"), (List)data.get("saturation_modifiers"), (Consumer)data.get("entity_action"), (Boolean)data.get("always_edible"), (Boolean)data.get("prevent_effects"))).allowCondition();
    }
}

