/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModifyDamageDealtPower
extends ValueModifyingPower {
    private final Predicate<Tuple<DamageSource, Float>> condition;
    private final Predicate<Entity> targetCondition;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;
    private Consumer<Entity> targetAction;
    private Consumer<Entity> selfAction;
    private Consumer<Tuple<Entity, Entity>> biEntityAction;

    public ModifyDamageDealtPower(PowerType<?> type, LivingEntity entity, Predicate<Tuple<DamageSource, Float>> condition, Predicate<Entity> targetCondition, Predicate<Tuple<Entity, Entity>> biEntityCondition) {
        super(type, entity);
        this.condition = condition;
        this.targetCondition = targetCondition;
        this.biEntityCondition = biEntityCondition;
    }

    public boolean doesApply(DamageSource source, float damageAmount, LivingEntity target) {
        return !(!this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount))) || target != null && this.targetCondition != null && !this.targetCondition.test((Entity)target) || target != null && this.biEntityCondition != null && !this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)target)));
    }

    public void setTargetAction(Consumer<Entity> targetAction) {
        this.targetAction = targetAction;
    }

    public void setBiEntityAction(Consumer<Tuple<Entity, Entity>> biEntityAction) {
        this.biEntityAction = biEntityAction;
    }

    public void setSelfAction(Consumer<Entity> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(Entity target) {
        if (this.selfAction != null) {
            this.selfAction.accept((Entity)this.entity);
        }
        if (this.targetAction != null) {
            this.targetAction.accept(target);
        }
        if (this.biEntityAction != null) {
            this.biEntityAction.accept((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)target));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_damage_dealt"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("target_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null), data -> (type, player) -> {
            ModifyDamageDealtPower power = new ModifyDamageDealtPower((PowerType<?>)type, (LivingEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"), (Predicate)data.get("bientity_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("bientity_action")) {
                power.setBiEntityAction((Consumer)data.get("bientity_action"));
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition();
    }
}

